/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.ColorFilter;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.UCropDevelopConfig;
import com.yalantis.ucrop.UCropFragment;
import com.yalantis.ucrop.UCropFragmentCallback;
import com.yalantis.ucrop.UCropGalleryAdapter;
import com.yalantis.ucrop.decoration.GridSpacingItemDecoration;
import com.yalantis.ucrop.model.AspectRatio;
import com.yalantis.ucrop.statusbar.ImmersiveManager;
import com.yalantis.ucrop.util.DensityUtil;
import com.yalantis.ucrop.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UCropMultipleActivity
extends AppCompatActivity
implements UCropFragmentCallback {
    private String mToolbarTitle;
    private int mToolbarTitleSize;
    private int mToolbarColor;
    private int mStatusBarColor;
    @DrawableRes
    private int mToolbarCancelDrawable;
    @DrawableRes
    private int mToolbarCropDrawable;
    private int mToolbarWidgetColor;
    private boolean mShowLoader;
    private final List<UCropFragment> fragments = new ArrayList<UCropFragment>();
    private UCropFragment uCropCurrentFragment;
    private int currentFragmentPosition;
    private ArrayList<String> uCropSupportList;
    private ArrayList<String> uCropNotSupportList;
    private final LinkedHashMap<String, JSONObject> uCropTotalQueue = new LinkedHashMap();
    private String outputCropFileName;
    private UCropGalleryAdapter galleryAdapter;
    private boolean isForbidCropGifWebp;
    private boolean isSkipCropForbid;
    private ArrayList<AspectRatio> aspectRatioList;
    private final HashSet<String> filterSet = new HashSet();

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.immersive();
        this.setContentView(R.layout.ucrop_activity_multiple);
        this.setupViews(this.getIntent());
        this.initCropFragments();
    }

    private void immersive() {
        Intent intent = this.getIntent();
        boolean isDarkStatusBarBlack = intent.getBooleanExtra("com.yalantis.ucrop.isDarkStatusBarBlack", false);
        this.mStatusBarColor = intent.getIntExtra("com.yalantis.ucrop.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_statusbar));
        ImmersiveManager.immersiveAboveAPI23(this, this.mStatusBarColor, this.mStatusBarColor, isDarkStatusBarBlack);
    }

    private void initCropFragments() {
        this.isSkipCropForbid = this.getIntent().getBooleanExtra("com.yalantis.ucrop.ForbidSkipCrop", false);
        ArrayList totalCropData = this.getIntent().getStringArrayListExtra("com.yalantis.ucrop.CropTotalDataSource");
        if (totalCropData == null || totalCropData.size() <= 0) {
            throw new IllegalArgumentException("Missing required parameters, count cannot be less than 1");
        }
        this.uCropSupportList = new ArrayList();
        this.uCropNotSupportList = new ArrayList();
        for (int i = 0; i < totalCropData.size(); ++i) {
            String path = (String)totalCropData.get(i);
            this.uCropTotalQueue.put(path, new JSONObject());
            String realPath = FileUtils.isContent(path) ? FileUtils.getPath((Context)this, Uri.parse((String)path)) : path;
            String mimeType = this.getPathToMimeType(path);
            if (FileUtils.isUrlHasVideo(realPath) || FileUtils.isHasVideo(mimeType) || FileUtils.isHasAudio(mimeType)) {
                this.uCropNotSupportList.add(path);
                continue;
            }
            this.uCropSupportList.add(path);
            Bundle extras = this.getIntent().getExtras();
            Uri inputUri = FileUtils.isContent(path) || FileUtils.isHasHttp(path) ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
            String postfix = FileUtils.getPostfixDefaultJPEG((Context)this, this.isForbidCropGifWebp, inputUri);
            String fileName = TextUtils.isEmpty((CharSequence)this.outputCropFileName) ? FileUtils.getCreateFileName("CROP_") + postfix : FileUtils.getCreateFileName() + "_" + this.outputCropFileName;
            Uri destinationUri = Uri.fromFile((File)new File(this.getSandboxPathDir(), fileName));
            extras.putParcelable("com.yalantis.ucrop.InputUri", (Parcelable)inputUri);
            extras.putParcelable("com.yalantis.ucrop.OutputUri", (Parcelable)destinationUri);
            AspectRatio aspectRatio = this.aspectRatioList != null && this.aspectRatioList.size() > i ? this.aspectRatioList.get(i) : null;
            extras.putFloat("com.yalantis.ucrop.AspectRatioX", aspectRatio != null ? aspectRatio.getAspectRatioX() : -1.0f);
            extras.putFloat("com.yalantis.ucrop.AspectRatioY", aspectRatio != null ? aspectRatio.getAspectRatioY() : -1.0f);
            UCropFragment uCropFragment = UCropFragment.newInstance(extras);
            this.fragments.add(uCropFragment);
        }
        if (this.uCropSupportList.size() == 0) {
            throw new IllegalArgumentException("No clipping data sources are available");
        }
        this.setGalleryAdapter();
        UCropFragment uCropFragment = this.fragments.get(this.getCropSupportPosition());
        this.switchCropFragment(uCropFragment, this.getCropSupportPosition());
        this.galleryAdapter.setCurrentSelectPosition(this.getCropSupportPosition());
    }

    private int getCropSupportPosition() {
        int position = 0;
        ArrayList skipCropMimeType = this.getIntent().getExtras().getStringArrayList("com.yalantis.ucrop.SkipCropMimeType");
        if (skipCropMimeType != null && skipCropMimeType.size() > 0) {
            position = -1;
            this.filterSet.addAll(skipCropMimeType);
            for (int i = 0; i < this.uCropSupportList.size(); ++i) {
                String path = this.uCropSupportList.get(i);
                String mimeType = this.getPathToMimeType(path);
                ++position;
                if (!this.filterSet.contains(mimeType)) break;
            }
            if (position == -1 || position > this.fragments.size()) {
                position = 0;
            }
        }
        return position;
    }

    private String getPathToMimeType(String path) {
        String mimeType = FileUtils.isContent(path) ? FileUtils.getMimeTypeFromMediaContentUri((Context)this, Uri.parse((String)path)) : FileUtils.getMimeTypeFromMediaContentUri((Context)this, Uri.fromFile((File)new File(path)));
        return mimeType;
    }

    private void switchCropFragment(UCropFragment targetFragment, int position) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        if (!targetFragment.isAdded()) {
            if (this.uCropCurrentFragment != null) {
                transaction.hide((Fragment)this.uCropCurrentFragment);
            }
            transaction.add(R.id.fragment_container, (Fragment)targetFragment, UCropFragment.TAG + "-" + position);
        } else {
            transaction.hide((Fragment)this.uCropCurrentFragment).show((Fragment)targetFragment);
            targetFragment.fragmentReVisible();
        }
        this.currentFragmentPosition = position;
        this.uCropCurrentFragment = targetFragment;
        transaction.commitAllowingStateLoss();
    }

    private void setGalleryAdapter() {
        RecyclerView galleryRecycle = (RecyclerView)this.findViewById(R.id.recycler_gallery);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(0);
        galleryRecycle.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        if (galleryRecycle.getItemDecorationCount() == 0) {
            galleryRecycle.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(Integer.MAX_VALUE, DensityUtil.dip2px((Context)this, 6.0f), true));
        }
        LayoutAnimationController animation = AnimationUtils.loadLayoutAnimation((Context)this, (int)R.anim.ucrop_layout_animation_fall_down);
        galleryRecycle.setLayoutAnimation(animation);
        int galleryBarBackground = this.getIntent().getIntExtra("com.yalantis.ucrop.GalleryBarBackground", R.drawable.ucrop_gallery_bg);
        galleryRecycle.setBackgroundResource(galleryBarBackground);
        this.galleryAdapter = new UCropGalleryAdapter(this.uCropSupportList);
        this.galleryAdapter.setOnItemClickListener(new UCropGalleryAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, View view) {
                if (UCropMultipleActivity.this.isSkipCropForbid) {
                    return;
                }
                String path = (String)UCropMultipleActivity.this.uCropSupportList.get(position);
                String mimeType = UCropMultipleActivity.this.getPathToMimeType(path);
                if (UCropMultipleActivity.this.filterSet.contains(mimeType)) {
                    Toast.makeText((Context)UCropMultipleActivity.this.getApplicationContext(), (CharSequence)UCropMultipleActivity.this.getString(R.string.ucrop_not_crop), (int)0).show();
                    return;
                }
                if (UCropMultipleActivity.this.galleryAdapter.getCurrentSelectPosition() == position) {
                    return;
                }
                UCropMultipleActivity.this.galleryAdapter.notifyItemChanged(UCropMultipleActivity.this.galleryAdapter.getCurrentSelectPosition());
                UCropMultipleActivity.this.galleryAdapter.setCurrentSelectPosition(position);
                UCropMultipleActivity.this.galleryAdapter.notifyItemChanged(position);
                UCropFragment uCropFragment = (UCropFragment)((Object)UCropMultipleActivity.this.fragments.get(position));
                UCropMultipleActivity.this.switchCropFragment(uCropFragment, position);
            }
        });
        galleryRecycle.setAdapter((RecyclerView.Adapter)this.galleryAdapter);
    }

    private String getSandboxPathDir() {
        String outputDir = this.getIntent().getStringExtra("com.yalantis.ucrop.CropOutputDir");
        File customFile = outputDir == null || "".equals(outputDir) ? new File(this.getExternalFilesDir(Environment.DIRECTORY_PICTURES).getAbsolutePath(), "Sandbox") : new File(outputDir);
        if (!customFile.exists()) {
            customFile.mkdirs();
        }
        return customFile.getAbsolutePath() + File.separator;
    }

    private void setupViews(@NonNull Intent intent) {
        this.aspectRatioList = this.getIntent().getParcelableArrayListExtra("com.yalantis.ucrop.MultipleAspectRatio");
        this.isForbidCropGifWebp = intent.getBooleanExtra("com.yalantis.ucrop.ForbidCropGifWebp", false);
        this.outputCropFileName = intent.getStringExtra("com.yalantis.ucrop.CropOutputFileName");
        this.mStatusBarColor = intent.getIntExtra("com.yalantis.ucrop.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_statusbar));
        this.mToolbarColor = intent.getIntExtra("com.yalantis.ucrop.ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar));
        this.mToolbarWidgetColor = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarWidgetColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar_widget));
        this.mToolbarCancelDrawable = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarCancelDrawable", R.drawable.ucrop_ic_cross);
        this.mToolbarCropDrawable = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarCropDrawable", R.drawable.ucrop_ic_done);
        this.mToolbarTitle = intent.getStringExtra("com.yalantis.ucrop.UcropToolbarTitleText");
        this.mToolbarTitleSize = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarTitleTextSize", 18);
        this.mToolbarTitle = this.mToolbarTitle != null ? this.mToolbarTitle : this.getResources().getString(R.string.ucrop_label_edit_photo);
        this.setupAppBar();
    }

    private void setupAppBar() {
        this.setStatusBarColor(this.mStatusBarColor);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        toolbar.setBackgroundColor(this.mToolbarColor);
        toolbar.setTitleTextColor(this.mToolbarWidgetColor);
        TextView toolbarTitle = (TextView)toolbar.findViewById(R.id.toolbar_title);
        toolbarTitle.setTextColor(this.mToolbarWidgetColor);
        toolbarTitle.setText((CharSequence)this.mToolbarTitle);
        toolbarTitle.setTextSize((float)this.mToolbarTitleSize);
        Drawable stateButtonDrawable = AppCompatResources.getDrawable((Context)this, (int)this.mToolbarCancelDrawable).mutate();
        ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mToolbarWidgetColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
        stateButtonDrawable.setColorFilter(colorFilter);
        toolbar.setNavigationIcon(stateButtonDrawable);
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayShowTitleEnabled(false);
        }
    }

    @TargetApi(value=21)
    private void setStatusBarColor(@ColorInt int color2) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21 && (window = this.getWindow()) != null) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    @Override
    public void loadingProgress(boolean showLoader) {
        this.mShowLoader = showLoader;
        this.supportInvalidateOptionsMenu();
    }

    @Override
    public void onCropFinish(UCropFragment.UCropResult result) {
        switch (result.mResultCode) {
            case -1: {
                int realPosition = this.currentFragmentPosition + this.uCropNotSupportList.size();
                int realTotalSize = this.uCropNotSupportList.size() + this.uCropSupportList.size() - 1;
                this.mergeCropResult(result.mResultData);
                if (realPosition == realTotalSize) {
                    this.onCropCompleteFinish();
                    break;
                }
                int nextFragmentPosition = this.currentFragmentPosition + 1;
                String path = this.uCropSupportList.get(nextFragmentPosition);
                String mimeType = this.getPathToMimeType(path);
                boolean isCropCompleteFinish = false;
                while (this.filterSet.contains(mimeType)) {
                    if (nextFragmentPosition == realTotalSize) {
                        isCropCompleteFinish = true;
                        break;
                    }
                    path = this.uCropSupportList.get(++nextFragmentPosition);
                    mimeType = this.getPathToMimeType(path);
                }
                if (isCropCompleteFinish) {
                    this.onCropCompleteFinish();
                    break;
                }
                UCropFragment uCropFragment = this.fragments.get(nextFragmentPosition);
                this.switchCropFragment(uCropFragment, nextFragmentPosition);
                this.galleryAdapter.notifyItemChanged(this.galleryAdapter.getCurrentSelectPosition());
                this.galleryAdapter.setCurrentSelectPosition(nextFragmentPosition);
                this.galleryAdapter.notifyItemChanged(this.galleryAdapter.getCurrentSelectPosition());
                break;
            }
            case 96: {
                this.handleCropError(result.mResultData);
            }
        }
    }

    private void onCropCompleteFinish() {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, JSONObject> stringJSONObjectEntry : this.uCropTotalQueue.entrySet()) {
            JSONObject object = stringJSONObjectEntry.getValue();
            array.put((Object)object);
        }
        Intent intent = new Intent();
        intent.putExtra("output", array.toString());
        this.setResult(-1, intent);
        this.finish();
    }

    private void mergeCropResult(Intent intent) {
        try {
            String key = intent.getStringExtra("com.yalantis.ucrop.CropInputOriginal");
            JSONObject uCropObject = this.uCropTotalQueue.get(key);
            Uri output = UCrop.getOutput(intent);
            uCropObject.put("outPutPath", (Object)(output != null ? output.getPath() : ""));
            uCropObject.put("imageWidth", UCrop.getOutputImageWidth(intent));
            uCropObject.put("imageHeight", UCrop.getOutputImageHeight(intent));
            uCropObject.put("offsetX", UCrop.getOutputImageOffsetX(intent));
            uCropObject.put("offsetY", UCrop.getOutputImageOffsetY(intent));
            uCropObject.put("aspectRatio", (double)UCrop.getOutputCropAspectRatio(intent));
            this.uCropTotalQueue.put(key, uCropObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleCropError(@NonNull Intent result) {
        Throwable cropError = UCrop.getError(result);
        if (cropError != null) {
            Toast.makeText((Context)this, (CharSequence)cropError.getMessage(), (int)1).show();
        } else {
            Toast.makeText((Context)this, (CharSequence)"Unexpected error", (int)0).show();
        }
    }

    protected void onDestroy() {
        UCropDevelopConfig.destroy();
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ucrop_menu_activity, menu2);
        MenuItem menuItemLoader = menu2.findItem(R.id.menu_loader);
        Drawable menuItemLoaderIcon = menuItemLoader.getIcon();
        if (menuItemLoaderIcon != null) {
            try {
                menuItemLoaderIcon.mutate();
                ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mToolbarWidgetColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                menuItemLoaderIcon.setColorFilter(colorFilter);
                menuItemLoader.setIcon(menuItemLoaderIcon);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            ((Animatable)menuItemLoader.getIcon()).start();
        }
        MenuItem menuItemCrop = menu2.findItem(R.id.menu_crop);
        Drawable menuItemCropIcon = ContextCompat.getDrawable((Context)this, (int)this.mToolbarCropDrawable);
        if (menuItemCropIcon != null) {
            menuItemCropIcon.mutate();
            ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mToolbarWidgetColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
            menuItemCropIcon.setColorFilter(colorFilter);
            menuItemCrop.setIcon(menuItemCropIcon);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.findItem(R.id.menu_crop).setVisible(!this.mShowLoader);
        menu2.findItem(R.id.menu_loader).setVisible(this.mShowLoader);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_crop) {
            if (this.uCropCurrentFragment != null && this.uCropCurrentFragment.isAdded()) {
                this.uCropCurrentFragment.cropAndSaveImage();
            }
        } else if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }
}

