/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.statusbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.yalantis.ucrop.statusbar.RomUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class LightStatusBarUtils {
    public static void setLightStatusBarAboveAPI23(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean dark) {
        if (Build.VERSION.SDK_INT >= 23) {
            LightStatusBarUtils.setLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
        }
    }

    public static void setLightStatusBar(Activity activity, boolean dark) {
        LightStatusBarUtils.setLightStatusBar(activity, false, false, false, dark);
    }

    public static void setLightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean dark) {
        switch (RomUtils.getLightStatausBarAvailableRomType()) {
            case 1: {
                if (RomUtils.getMIUIVersionCode() >= 7) {
                    LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                    break;
                }
                LightStatusBarUtils.setMIUILightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                break;
            }
            case 2: {
                LightStatusBarUtils.setFlymeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                break;
            }
            case 3: {
                LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                break;
            }
        }
    }

    private static boolean setMIUILightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean darkmode) {
        LightStatusBarUtils.initStatusBarStyle(activity, isMarginStatusBar, isMarginNavigationBar);
        Class<?> clazz = activity.getWindow().getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkmode ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception e) {
            LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, darkmode);
            return false;
        }
    }

    private static boolean setFlymeLightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean dark) {
        boolean result = false;
        if (activity != null) {
            LightStatusBarUtils.initStatusBarStyle(activity, isMarginStatusBar, isMarginNavigationBar);
            try {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                activity.getWindow().setAttributes(lp);
                result = true;
                if (RomUtils.getFlymeVersion() >= 7) {
                    LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
                }
            }
            catch (Exception e) {
                LightStatusBarUtils.setAndroidNativeLightStatusBar(activity, isMarginStatusBar, isMarginNavigationBar, isTransStatusBar, dark);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=11)
    private static void setAndroidNativeLightStatusBar(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar, boolean isTransStatusBar, boolean isDarkStatusBarIcon) {
        try {
            if (isTransStatusBar) {
                Window window = activity.getWindow();
                if (Build.VERSION.SDK_INT < 21) return;
                if (isMarginStatusBar && isMarginNavigationBar) {
                    if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                        window.getDecorView().setSystemUiVisibility(8448);
                        return;
                    } else {
                        window.getDecorView().setSystemUiVisibility(256);
                    }
                    return;
                } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                    if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                        window.getDecorView().setSystemUiVisibility(9472);
                        return;
                    } else {
                        window.getDecorView().setSystemUiVisibility(1280);
                    }
                    return;
                } else {
                    if (isMarginStatusBar || !isMarginNavigationBar) return;
                    if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                        window.getDecorView().setSystemUiVisibility(9472);
                        return;
                    } else {
                        window.getDecorView().setSystemUiVisibility(1280);
                    }
                }
                return;
            } else {
                View decor = activity.getWindow().getDecorView();
                if (isDarkStatusBarIcon && Build.VERSION.SDK_INT >= 23) {
                    decor.setSystemUiVisibility(8192);
                    return;
                } else {
                    decor.setSystemUiVisibility(0);
                }
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initStatusBarStyle(Activity activity, boolean isMarginStatusBar, boolean isMarginNavigationBar) {
        if (Build.VERSION.SDK_INT >= 16) {
            if (isMarginStatusBar && isMarginNavigationBar) {
                activity.getWindow().getDecorView().setSystemUiVisibility(256);
            } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            } else if (!isMarginStatusBar && isMarginNavigationBar) {
                activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            }
        }
    }
}

