/*
 * Decompiled with CFR 0.152.
 */
package io.github.luidmidev.jakarta.validations;

import io.github.luidmidev.jakarta.validations.constraints.dimensions.ImageValidatorForArraysOfByte;
import io.github.luidmidev.jakarta.validations.constraints.dimensions.ImageValidatorForFile;
import io.github.luidmidev.jakarta.validations.constraints.dimensions.ImageValidatorForMultipartFile;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Function;
import lombok.Generated;

@Documented
@Constraint(validatedBy={ImageValidatorForArraysOfByte.class, ImageValidatorForFile.class, ImageValidatorForMultipartFile.class})
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Image {
    public String message() default "{my.validation.constraints.Image.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public long width() default 0L;

    public long height() default 0L;

    public DimensionConstraint dimensionValidation() default DimensionConstraint.NO_VALIDATION;

    public record ArgsDimensionValidation(long widthObtained, long widthExpected, long heightObtained, long heightExpected) {
    }

    public static enum DimensionConstraint {
        MAX(args -> args.widthObtained <= args.widthExpected && args.heightObtained <= args.heightExpected),
        MIN(args -> args.widthObtained >= args.widthExpected && args.heightObtained >= args.heightExpected),
        EXACT(args -> args.widthObtained == args.widthExpected && args.heightObtained == args.heightExpected),
        ASPECT_RATIO(args -> args.widthObtained / args.heightObtained == args.widthExpected / args.heightExpected),
        MAX_WIDTH(args -> args.widthObtained <= args.widthExpected),
        MIN_WIDTH(args -> args.widthObtained >= args.widthExpected),
        MAX_HEIGHT(args -> args.heightObtained <= args.heightExpected),
        MIN_HEIGHT(args -> args.heightObtained >= args.heightExpected),
        NO_VALIDATION(args -> true);

        private final Function<ArgsDimensionValidation, Boolean> validationFuntion;
        private final String message = "{my.validation.constraints.Image.DimensionValidation." + this.name() + ".message}";

        public boolean isValid(long widthObtained, long widthExpected, long heightObtained, long heightExpected) {
            return this.validationFuntion.apply(new ArgsDimensionValidation(widthObtained, widthExpected, heightObtained, heightExpected));
        }

        @Generated
        private DimensionConstraint(Function<ArgsDimensionValidation, Boolean> validationFuntion) {
            this.validationFuntion = validationFuntion;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

