/*
 * Decompiled with CFR 0.152.
 */
package io.github.luidmidev.jakarta.validations.constraints;

import io.github.luidmidev.jakarta.validations.Password;
import io.github.luidmidev.jakarta.validations.utils.LocaleContext;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PropertiesMessageResolver;
import org.passay.Rule;
import org.passay.RuleResult;

public class PasswordValidator
implements ConstraintValidator<Password, String> {
    private static final Map<Locale, Properties> PROPERTIES = new HashMap<Locale, Properties>();
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String RESOURCE_PREFIX = "passay";
    private static final Locale[] availableLocales = Locale.getAvailableLocales();
    private List<? extends Rule> rules;

    private static InputStream loadResource(String constraintAnnotation) {
        return PasswordValidator.class.getClassLoader().getResourceAsStream(constraintAnnotation);
    }

    public void initialize(Password password) {
        try {
            this.rules = password.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Invalid rule configuration", e);
        }
    }

    private org.passay.PasswordValidator buildPassswordValidator() {
        Properties props = PROPERTIES.getOrDefault(LocaleContext.getLocale(), DEFAULT_PROPERTIES);
        return new org.passay.PasswordValidator((MessageResolver)new PropertiesMessageResolver(props), this.rules);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        PasswordData passwordData;
        org.passay.PasswordValidator validator = this.buildPassswordValidator();
        RuleResult result = validator.validate(passwordData = new PasswordData(value == null ? "" : value));
        if (result.isValid()) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        for (String message : validator.getMessages(result)) {
            context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
        }
        return false;
    }

    static {
        try {
            for (Locale locale : availableLocales) {
                InputStream inputStream = PasswordValidator.loadResource("passay_" + locale.getLanguage() + ".properties");
                if (inputStream == null) continue;
                Properties props = new Properties();
                props.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                PROPERTIES.put(locale, props);
            }
            InputStream inputStream = PasswordValidator.loadResource("passay.properties");
            DEFAULT_PROPERTIES.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

