/*
 * Decompiled with CFR 0.152.
 */
package io.github.luidmidev.jakarta.validations.constraints.adult;

import io.github.luidmidev.jakarta.validations.Adult;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;

public class AdultValidatorForDate
implements ConstraintValidator<Adult, Date> {
    private int min;

    public void initialize(Adult constraintAnnotation) {
        this.min = constraintAnnotation.min();
    }

    public boolean isValid(Date value, ConstraintValidatorContext context) {
        LocalDate now;
        if (value == null) {
            return false;
        }
        LocalDate valueLcalDate = value.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (valueLcalDate.isAfter(now = LocalDate.now())) {
            return false;
        }
        return Period.between(valueLcalDate, now).getYears() >= this.min;
    }
}

