/*
 * Decompiled with CFR 0.152.
 */
package io.github.luidmidev.jakarta.validations.constraints.adult;

import io.github.luidmidev.jakarta.validations.Adult;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.LocalDate;
import java.time.Period;

public class AdultValidatorForLocalDate
implements ConstraintValidator<Adult, LocalDate> {
    private int min;

    public void initialize(Adult constraintAnnotation) {
        this.min = constraintAnnotation.min();
    }

    public boolean isValid(LocalDate value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        LocalDate now = LocalDate.now();
        if (value.isAfter(now)) {
            return false;
        }
        return Period.between(value, now).getYears() >= this.min;
    }
}

