/*
 * Decompiled with CFR 0.152.
 */
package io.github.luidmidev.jakarta.validations.constraints.dimensions;

import io.github.luidmidev.jakarta.validations.Image;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public abstract class ImageValidator<T>
implements ConstraintValidator<Image, T> {
    private long expectedWidth;
    private long expectedHeight;
    private Image.DimensionConstraint dimensionValidation;

    public void initialize(Image annotation) {
        this.expectedWidth = annotation.width();
        this.expectedHeight = annotation.height();
        this.dimensionValidation = annotation.dimensionValidation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(T value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        BufferedImage image = null;
        try {
            int heightObtained;
            image = ImageIO.read(this.getInputStream(value));
            if (image == null) {
                boolean bl = false;
                return bl;
            }
            int widthObtained = image.getWidth();
            boolean valid = this.dimensionValidation.isValid(widthObtained, this.expectedWidth, heightObtained = image.getHeight(), this.expectedHeight);
            if (!valid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.dimensionValidation.getMessage()).addConstraintViolation();
            }
            boolean bl = valid;
            return bl;
        }
        catch (IOException e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Error reading image file: " + e.getMessage()).addConstraintViolation();
            boolean bl = false;
            return bl;
        }
        finally {
            if (image != null) {
                image.flush();
            }
        }
    }

    public abstract InputStream getInputStream(T var1) throws IOException;
}

