/*
 * Decompiled with CFR 0.152.
 */
package io.github.luidmidev.jakarta.validations.constraints.filesize;

import io.github.luidmidev.jakarta.validations.FileSize;
import io.github.luidmidev.jakarta.validations.Validations;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.File;

public class FileSizeValidatorForFile
implements ConstraintValidator<FileSize, File> {
    private float maxFileSize;
    private FileSize.Unit unit;

    public void initialize(FileSize constraintAnnotation) {
        this.maxFileSize = constraintAnnotation.value();
        this.unit = constraintAnnotation.unit();
    }

    public boolean isValid(File file, ConstraintValidatorContext context) {
        return Validations.isValidFileSize(file.length(), this.maxFileSize, this.unit);
    }
}

