/*
 * Decompiled with CFR 0.152.
 */
package docsite;

import docsite.Docsite;
import docsite.Logger;
import docsite.Script;
import docsite.Section;
import docsite.SectionEmitterFactory;
import docsite.ThemeColors;
import docsite.util.EmitterUtil;
import docsite.util.ImageResolver;
import docsite.util.ResourceUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class DocsiteEmitter {
    private static final Logger logger = Logger.instance();
    private final Docsite site;
    private final ImageResolver globalImages;
    private final ThemeColors themeColors;
    private final Path baseDir;
    private final Path outputFolder;
    private final Path cssFile;
    private final boolean useCDN;
    private final Map<String, String> metadata;
    private final List<Script> scripts;

    public DocsiteEmitter(Docsite docsite, ThemeColors themeColors, Path cssFile, boolean useCDN, Path baseDir, Path outputFolder, Map<String, String> metadata, List<Script> scripts) {
        this.site = docsite;
        this.themeColors = themeColors;
        this.cssFile = cssFile;
        this.outputFolder = outputFolder;
        this.globalImages = new ImageResolver(outputFolder.resolve("images"));
        this.useCDN = useCDN;
        this.metadata = metadata;
        this.scripts = scripts;
        this.baseDir = baseDir;
    }

    public void generateSite() throws IOException {
        this.prepareCommonResources();
        SectionEmitterFactory emitterFactory = new SectionEmitterFactory(this.site, this.globalImages, this.themeColors, this.baseDir, this.outputFolder, this.useCDN, this.metadata, this.scripts);
        emitterFactory.createEmitter(this.site.home()).emitHTML(true);
    }

    private void prepareCommonResources() throws IOException {
        logger.debug("Copying common resources...", new Object[0]);
        Path cssFolder = this.outputFolder.resolve("css");
        Path jsFolder = this.outputFolder.resolve("js");
        if (this.cssFile == null) {
            ResourceUtil.copyResource("css/style.css", cssFolder);
        } else {
            ResourceUtil.copyExternalFileWithAnotherName(this.cssFile, cssFolder, "style.css");
        }
        ResourceUtil.copyResource("css/common.css", cssFolder);
        ResourceUtil.copyResource("css/prism.min.css", cssFolder);
        if (!this.useCDN) {
            ResourceUtil.copyResource("js/prism.js", jsFolder);
            ResourceUtil.copyResourceFolder("webfonts", this.outputFolder);
        }
        this.site.sections().forEach(this::copyEmbeddedSites);
        this.site.sections().forEach(this::copyLocalSites);
    }

    private void copyEmbeddedSites(Section section) {
        logger.debug("Copying embedded site {}", section.source());
        if (section.type() == Section.SectionType.embedded && section.isValid(this.baseDir)) {
            ResourceUtil.copyFolder(this.baseDir.resolve(section.source()), this.outputFolder.resolve(EmitterUtil.href(section.name())));
        }
        section.subsections().forEach(this::copyEmbeddedSites);
    }

    private void copyLocalSites(Section section) {
        logger.debug("Copying local site {}", section.source());
        if (section.type() == Section.SectionType.copy && section.isValid(this.baseDir)) {
            ResourceUtil.copyFolder(this.baseDir.resolve(section.source()), this.outputFolder.resolve(section.source()));
        }
        section.subsections().forEach(this::copyLocalSites);
    }
}

