/*
 * Decompiled with CFR 0.152.
 */
package docsite.emitters;

import docsite.EmitterBuildParams;
import docsite.SectionEmitter;
import docsite.util.EmitterUtil;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.AsideTag;
import j2html.tags.specialized.NavTag;
import j2html.tags.specialized.SectionTag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GeneratedSectionEmitter
extends SectionEmitter {
    GeneratedSectionEmitter(EmitterBuildParams params) {
        super(params);
    }

    @Override
    protected String url() {
        return EmitterUtil.page(this.section.name());
    }

    @Override
    public ATag createLinkToSection(boolean withIcon) {
        return withIcon ? EmitterUtil.internalLinkWithIcon(this.baseDir, this.section.name(), this.url(), this.section.icon(), this.globalImages) : EmitterUtil.internalLink(this.section.name(), this.url());
    }

    @Override
    protected AsideTag createTableOfContents(SectionTag section) {
        return this.createTableOfContentsFromHtml(section.render());
    }

    protected String replaceLocalImages(String html) {
        Matcher matcher = Pattern.compile("<img .*src=\"([^\"]+)\".*>").matcher(html);
        while (matcher.find()) {
            String src = matcher.group(1);
            if (src.startsWith("http")) continue;
            html = html.replace("src=\"" + src + "\"", "src=\"" + this.sectionImages.imageFile(src) + "\"");
        }
        return html;
    }

    protected String hrefId(String name) {
        return name.strip().toLowerCase().replace(" ", "-");
    }

    protected String normalizeLinks(String html) {
        return html.replaceAll("<a href([^>]*)>([^<]*)<([^<]*)</a>", "<a target=\"_blank\" rel=\"external noreferrer noopener nofollow\" href$1>$2<$3</a>").replaceAll("<a href([^>]*)>([^<]*)</a>", "<a class=\"external\" target=\"_blank\" rel=\"external noreferrer noopener nofollow\" href$1>$2</a>");
    }

    protected String generateHeadersId(String html) {
        Matcher matcher = Pattern.compile("<(h\\d)>([^<]*)").matcher(html);
        while (matcher.find()) {
            String tag = matcher.group(1);
            String name = matcher.group(2);
            String id = this.hrefId(name);
            if (id.isEmpty()) continue;
            html = html.replace("<" + tag + ">" + name, "<" + tag + " id=\"" + id + "\">" + name);
        }
        return html;
    }

    protected AsideTag createTableOfContentsFromHtml(String html) {
        Matcher matcher = Pattern.compile("<h(\\d)[^>]*>([^<]*)<").matcher(html);
        StringBuilder string = new StringBuilder();
        int previousLevel = 1;
        boolean empty = true;
        while (matcher.find()) {
            int level = Integer.parseInt(matcher.group(1));
            String name = matcher.group(2);
            String id = this.hrefId(name);
            if (level < 2 || level > 3 || id.isEmpty()) continue;
            if (previousLevel > level) {
                string.append("</ol>".repeat(Math.max(0, previousLevel - level)));
            } else {
                string.append("<ol>".repeat(Math.max(0, level - previousLevel)));
            }
            string.append("<li><a class=\"internal\" href=\"#").append(id).append("\">").append(name).append("</a></li>");
            previousLevel = level;
            empty = false;
        }
        if (empty) {
            return TagCreator.aside();
        }
        string.append("</ol>".repeat(previousLevel));
        return (AsideTag)TagCreator.aside().with((DomContent)((NavTag)TagCreator.nav().with((DomContent)TagCreator.rawHtml((String)string.toString()))).withClass("toc"));
    }
}

