/*
 * Decompiled with CFR 0.152.
 */
package docsite.util;

import docsite.DocsiteException;
import docsite.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlParser {
    private static final DocumentBuilder documentBuilder = XmlParser.documentBuilder();

    private static DocumentBuilder documentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DocsiteException(e);
        }
    }

    public Map<String, Object> parse(InputStream inputStream) throws IOException {
        try {
            String xml = ResourceUtil.read(inputStream).replaceAll(">[\\s]*<", "><");
            StringReader reader = new StringReader(xml);
            InputSource inputSource = new InputSource(reader);
            Document document = documentBuilder.parse(inputSource);
            return this.documentToMap(document);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private Map<String, Object> documentToMap(Document document) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Element node = document.getDocumentElement();
        this.processNode(node, map, null, 1);
        return map;
    }

    private void processNode(Node node, Map<String, Object> map, List<Object> list, int level) {
        if (!this.isElement(node)) {
            return;
        }
        Element element = (Element)node;
        if (!element.hasChildNodes() && !element.hasAttributes()) {
            this.addToContainer(map, list, element.getTagName(), "");
        } else if (this.childCount(node) == 1 && this.isText(this.child(node, 0)) && !element.hasAttributes()) {
            this.addToContainer(map, list, element.getTagName(), this.child(node, 0).getNodeValue());
        } else if (this.childCount(node) == 1 && this.isText(this.child(node, 0)) && element.hasAttributes()) {
            TreeMap<String, String> value = new TreeMap<String, String>();
            this.addToContainer(map, list, element.getTagName(), value);
            this.attributes(node).forEach(attr -> value.put(attr.getName(), attr.getValue()));
            value.put("value", this.child(node, 0).getNodeValue());
        } else if (this.isListPropertyNode(node)) {
            ArrayList value = new ArrayList();
            this.addToContainer(map, list, element.getTagName(), value);
            this.children(node).forEach(child -> this.processNode((Node)child, (Map<String, Object>)new TreeMap<String, Object>(), value, level + 1));
        } else {
            TreeMap value = new TreeMap();
            this.addToContainer(map, list, element.getTagName(), value);
            this.attributes(node).forEach(attr -> value.put(attr.getName(), attr.getValue()));
            this.children(node).forEach(child -> this.processNode((Node)child, value, null, level + 1));
        }
    }

    private void addToContainer(Map<String, Object> map, List<Object> list, String key, Object value) {
        if (list != null) {
            list.add(value);
        } else {
            map.put(key, value);
        }
    }

    private boolean isListPropertyNode(Node node) {
        if (this.isElement(node) && node.hasChildNodes()) {
            String childTag = "";
            int count = 0;
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = this.child(node, i);
                if (!this.isElement(child)) continue;
                ++count;
                if (childTag.isEmpty()) {
                    childTag = child.getNodeName();
                    continue;
                }
                if (childTag.equals(child.getNodeName())) continue;
                return false;
            }
            return count > 1 && !childTag.isEmpty();
        }
        return false;
    }

    private boolean isElement(Node node) {
        return node.getNodeType() == 1;
    }

    private boolean isText(Node node) {
        return node.getNodeType() == 3;
    }

    private int childCount(Node node) {
        return node.getChildNodes().getLength();
    }

    private Node child(Node node, int index) {
        return node.getChildNodes().item(index);
    }

    private Stream<Node> children(Node node) {
        return IntStream.rangeClosed(0, node.getChildNodes().getLength() - 1).mapToObj(node.getChildNodes()::item);
    }

    private Stream<Attr> attributes(Node node) {
        return IntStream.rangeClosed(0, node.getAttributes().getLength() - 1).mapToObj(node.getAttributes()::item).map(Attr.class::cast);
    }
}

