/*
 * Decompiled with CFR 0.152.
 */
package docsite;

import docsite.util.ResourceUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class Section {
    private String name;
    private String description;
    private String icon;
    private String source;
    private SectionType type;
    private String siteIndex;
    private List<Section> subsections;
    private Boolean replaceEmojis;
    private String template;

    public Section() {
    }

    public Section(String name, String description, String icon, String source, SectionType type, String siteIndex, List<Section> subsections, Boolean replaceEmojis, String template) {
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.source = source;
        this.type = type;
        this.siteIndex = siteIndex;
        this.subsections = subsections;
        this.replaceEmojis = replaceEmojis;
        this.template = template;
    }

    public static SectionBuilder generated(String name) {
        return Section.builder().type(SectionType.generated).name(name);
    }

    public static SectionBuilder site() {
        return Section.builder().type(SectionType.embedded);
    }

    public static SectionBuilder copy() {
        return Section.builder().type(SectionType.copy);
    }

    public static SectionBuilder group(String name) {
        return Section.builder().type(SectionType.group).name(name);
    }

    public static SectionBuilder link() {
        return Section.builder().type(SectionType.link);
    }

    public static SectionBuilder builder() {
        return new SectionBuilder();
    }

    public String name() {
        return Objects.requireNonNullElse(this.name, "");
    }

    public String description() {
        return this.description;
    }

    public String icon() {
        return this.icon;
    }

    public String source() {
        return this.source;
    }

    public SectionType type() {
        return this.type;
    }

    public String template() {
        return this.template;
    }

    public List<Section> subsections() {
        return this.subsections == null ? List.of() : this.subsections;
    }

    public Boolean replaceEmojis() {
        return Objects.requireNonNullElse(this.replaceEmojis, Boolean.TRUE);
    }

    public String siteIndex() {
        return Objects.requireNonNullElse(this.siteIndex, "index.html");
    }

    public boolean isValid(Path baseDir) {
        return this.validation(baseDir).isEmpty();
    }

    public String validation(Path baseDir) {
        switch (this.type) {
            case generated: 
            case embedded: 
            case copy: {
                return !ResourceUtil.existsSource(baseDir, this.source) ? "Cannot find source " + this.source : "";
            }
            case link: {
                return this.source == null ? "Source not specified" : "";
            }
            case group: {
                return this.subsections().isEmpty() ? "Group must have subsections" : "";
            }
        }
        return "";
    }

    public static class SectionBuilder {
        private String name;
        private String description;
        private String icon;
        private String source;
        private SectionType type;
        private String siteIndex;
        private List<Section> subsections;
        private Boolean replaceEmojis;
        private String template;

        SectionBuilder() {
        }

        public SectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SectionBuilder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public SectionBuilder source(String source) {
            this.source = source;
            return this;
        }

        public SectionBuilder type(SectionType type) {
            this.type = type;
            return this;
        }

        public SectionBuilder siteIndex(String siteIndex) {
            this.siteIndex = siteIndex;
            return this;
        }

        public SectionBuilder subsections(List<Section> subsections) {
            this.subsections = subsections;
            return this;
        }

        public SectionBuilder replaceEmojis(Boolean replaceEmojis) {
            this.replaceEmojis = replaceEmojis;
            return this;
        }

        public SectionBuilder template(String template) {
            this.template = template;
            return this;
        }

        public Section build() {
            return new Section(this.name, this.description, this.icon, this.source, this.type, this.siteIndex, this.subsections, this.replaceEmojis, this.template);
        }
    }

    public static enum SectionType {
        generated,
        embedded,
        copy,
        group,
        link;

    }
}

