/*
 * Decompiled with CFR 0.152.
 */
package docsite;

import com.vdurmont.emoji.EmojiParser;
import docsite.Docsite;
import docsite.EmitterBuildParams;
import docsite.Logger;
import docsite.Script;
import docsite.Section;
import docsite.ThemeColors;
import docsite.util.CDNResources;
import docsite.util.EmitterUtil;
import docsite.util.ImageResolver;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.AsideTag;
import j2html.tags.specialized.BodyTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H1Tag;
import j2html.tags.specialized.HeadTag;
import j2html.tags.specialized.HeaderTag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.MetaTag;
import j2html.tags.specialized.NavTag;
import j2html.tags.specialized.OlTag;
import j2html.tags.specialized.ScriptTag;
import j2html.tags.specialized.SectionTag;
import j2html.tags.specialized.UlTag;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SectionEmitter {
    protected static final int TOC_MIN_LEVEL = 2;
    protected static final int TOC_MAX_LEVEL = 3;
    protected static final String INDEX_FILE = "index.html";
    protected static final Logger logger = Logger.instance();
    protected final Docsite site;
    protected final Section section;
    protected final String origin;
    protected final ImageResolver sectionImages;
    protected final ImageResolver globalImages;
    protected final boolean useCDN;
    protected final SectionEmitter rootEmitter;
    protected final List<SectionEmitter> ancestorEmitters;
    protected final List<SectionEmitter> childEmitters;
    protected final ThemeColors themeColors;
    protected final Path outputFolder;
    protected final Path baseDir;
    protected final Map<String, String> metadata;
    protected final List<Script> scripts;

    protected SectionEmitter(EmitterBuildParams params) {
        this.site = params.site();
        this.section = params.section();
        this.rootEmitter = Objects.requireNonNullElse(params.rootEmitter(), this);
        this.ancestorEmitters = List.copyOf(params.ancestorEmitters());
        this.childEmitters = new ArrayList<SectionEmitter>();
        this.origin = this.section.source();
        this.globalImages = params.globalImages();
        this.themeColors = params.themeColors();
        this.outputFolder = params.outputFolder();
        this.baseDir = params.baseDir();
        this.metadata = params.metadata();
        this.scripts = params.scripts();
        this.sectionImages = this.origin == null ? null : new ImageResolver(this.outputFolder.resolve("images").resolve(this.section.name()), this.baseDir.resolve(this.origin));
        this.useCDN = params.useCDN();
    }

    protected abstract String url();

    public abstract ATag createLinkToSection(boolean var1);

    protected abstract SectionTag createSectionContent();

    protected abstract AsideTag createTableOfContents(SectionTag var1);

    public String href() {
        return EmitterUtil.href(this.section.name());
    }

    protected Path outputPath() {
        return this.outputFolder.resolve(this.url());
    }

    public void emitHTML() throws IOException {
        this.emitHTML(false);
    }

    public void emitHTML(boolean includeFooter) throws IOException {
        if (!this.section.isValid(this.baseDir)) {
            logger.warn("Section {} is not valid and would not be included: {}", this.section.name(), this.section.validation(this.baseDir));
            return;
        }
        HeaderTag header = this.createHeader();
        NavTag breadcrumbs = this.createBreadcrumbs();
        SectionTag sectionContent = (SectionTag)this.createSectionContent().withId("content");
        if (includeFooter) {
            sectionContent.with((DomContent)TagCreator.rawHtml((String)("<div class=\"footer\">Generated with <a href=\"https://luiinge.github.io/docsite-maven-plugin/\" target=\"_blank_\">Docsite</a>. Last published on " + LocalDate.now() + "</div>")));
        }
        AsideTag tableOfContents = this.createTableOfContents(sectionContent);
        HeadTag head = this.htmlHead();
        if (this.useCDN) {
            this.addPrismComponents(head, sectionContent);
        }
        HtmlTag htmlObject = (HtmlTag)TagCreator.html().with(new DomContent[]{head, ((BodyTag)TagCreator.body().withCondClass(tableOfContents.getNumChildren() == 0, "empty-aside")).with(new DomContent[]{this.jumpToContentButton(), header, breadcrumbs, tableOfContents, sectionContent})});
        this.writeToFile(htmlObject);
        for (SectionEmitter child : this.childEmitters) {
            child.emitHTML();
        }
    }

    private ATag jumpToContentButton() {
        return (ATag)((ATag)((ATag)TagCreator.a().withId("jump-to-content")).withText("jump to content")).withHref("#content");
    }

    private HeaderTag createHeader() {
        return (HeaderTag)TagCreator.header().with(new DomContent[]{this.createTitleAndSubtitle(), this.createNavigation(), this.createCompanyLogo()});
    }

    public NavTag createBreadcrumbs() {
        OlTag container = TagCreator.ol();
        container.with((DomContent)TagCreator.li().with((DomContent)EmitterUtil.internalLink(this.site.title(), INDEX_FILE)));
        if (!this.ancestorEmitters.isEmpty()) {
            Iterator<SectionEmitter> iterator = this.ancestorEmitters.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                SectionEmitter path = iterator.next();
                if (path.section.isValid(this.baseDir)) {
                    container.with((DomContent)TagCreator.li().with((DomContent)path.createLinkToSection(false)));
                    continue;
                }
                container.with((DomContent)TagCreator.li().with((DomContent)TagCreator.a((String)path.section.name())));
            }
            container.with((DomContent)TagCreator.li().with((DomContent)TagCreator.a((String)this.section.name())));
        }
        return (NavTag)((NavTag)TagCreator.nav().withClass("breadcrumbs")).with((DomContent)container);
    }

    private DivTag createCompanyLogo() {
        if (this.site.companyLogo() != null && this.site.companyLink() != null) {
            return (DivTag)((DivTag)TagCreator.div().withClass("company")).with((DomContent)EmitterUtil.externalLinkWithImage(this.baseDir, "", this.site.companyLink(), this.site.companyLogo(), this.globalImages));
        }
        if (this.site.companyLink() == null) {
            return (DivTag)((DivTag)TagCreator.div().withClass("company")).with((DomContent)EmitterUtil.image(this.baseDir, this.site.companyLogo(), this.globalImages));
        }
        return TagCreator.div();
    }

    private HeadTag htmlHead() {
        String description;
        Object title = this.site.title();
        if (!this.section.name().equalsIgnoreCase((String)title) && !this.section.name().equals("index")) {
            title = (String)title + " - " + this.section.name();
        }
        if ((description = this.section.description()) == null || description.isEmpty()) {
            description = this.site.description();
        }
        HeadTag head = (HeadTag)((HeadTag)((HeadTag)((HeadTag)((HeadTag)TagCreator.head().with((DomContent)TagCreator.title((String)title))).with((DomContent)((MetaTag)TagCreator.meta().withName("description")).withContent(description))).with((DomContent)TagCreator.meta().withCharset("UTF-8"))).with((DomContent)((MetaTag)TagCreator.meta().withName("viewport")).withContent("width=device-width, initial-scale=1.0"))).with((DomContent)((LinkTag)TagCreator.link().withRel("profile")).withHref("http://www.w3.org/2005/10/profile"));
        if (this.site.favicon() != null) {
            head.with((DomContent)((LinkTag)((LinkTag)TagCreator.link().withRel("icon")).withType(this.globalImages.typeOf(this.site.favicon()))).withHref(this.globalImages.imageFile(this.site.favicon())));
        }
        if (this.useCDN) {
            CDNResources.css("fontawesome.min").ifPresent(arg_0 -> ((HeadTag)head).with(arg_0));
            CDNResources.css("prism.min").ifPresent(arg_0 -> ((HeadTag)head).with(arg_0));
            CDNResources.js("prism.min").ifPresent(arg_0 -> ((HeadTag)head).with(arg_0));
        } else {
            head.with((DomContent)EmitterUtil.stylesheet("css/font-awesome-all.css"));
            head.with((DomContent)TagCreator.script().attr("src", (Object)"js/prism.js"));
            head.with((DomContent)EmitterUtil.stylesheet("css/prism.min.css"));
        }
        head.with((DomContent)EmitterUtil.stylesheet("css/common.css"));
        head.with((DomContent)EmitterUtil.stylesheet("css/style.css"));
        String themeStyle = ":root {\n--menu-regular-background-color: " + this.themeColors.menuRegularBackgroundColor() + ";\n--menu-bold-background-color: " + this.themeColors.menuBoldBackgroundColor() + ";\n--menu-foreground-color: " + this.themeColors.menuForegroundColor() + ";\n--menu-decoration-color: " + this.themeColors.menuDecorationColor() + ";\n--gui-element-color: " + this.themeColors.guiElementColor() + ";\n}";
        head.with((DomContent)TagCreator.style((String)themeStyle));
        this.metadata.forEach((key, value) -> head.with((DomContent)((MetaTag)TagCreator.meta().withName(key)).withContent(value)));
        for (Script script : this.scripts) {
            if (script.code() != null && !script.code().isBlank()) {
                head.with((DomContent)TagCreator.script((String)script.code()));
                continue;
            }
            head.with((DomContent)((ScriptTag)TagCreator.script().withSrc(script.src())).withCondAsync(script.async()));
        }
        return head;
    }

    void addChildEmitter(SectionEmitter child) {
        this.childEmitters.add(child);
    }

    private DivTag createTitleAndSubtitle() {
        return (DivTag)((DivTag)TagCreator.div().withClass("title-and-subtitle")).with(new DomContent[]{((H1Tag)TagCreator.h1().withClasses(new String[]{"title label"})).with(new DomContent[]{EmitterUtil.icon(this.baseDir, this.site.logo(), this.globalImages), TagCreator.span((String)this.site.title())}), TagCreator.span((String)this.site.description()).withClass("subtitle")});
    }

    private NavTag createNavigation() {
        return (NavTag)((NavTag)TagCreator.nav().withClass("sections")).with((DomContent)TagCreator.ul().with((DomContent[])this.rootEmitter.childEmitters.stream().filter(it -> it.section.isValid(this.baseDir)).map(it -> it.createNavigationSection(it == this)).toArray(LiTag[]::new)));
    }

    private LiTag createNavigationSection(boolean selected) {
        if (!this.childEmitters.isEmpty()) {
            UlTag dropdownMenu = (UlTag)TagCreator.ul().withClass("dropdown");
            for (SectionEmitter child : this.childEmitters) {
                dropdownMenu.with((DomContent)TagCreator.li().with((DomContent)child.createLinkToSection(true)));
            }
            return (LiTag)((LiTag)((LiTag)TagCreator.li().withCondClass(selected, "selected")).with((DomContent)this.createLinkToSection(true))).with((DomContent)dropdownMenu);
        }
        return (LiTag)((LiTag)TagCreator.li().withCondClass(selected, "selected")).with((DomContent)this.createLinkToSection(true));
    }

    private void writeToFile(HtmlTag htmlObject) throws IOException {
        String html = htmlObject.render();
        if (Boolean.TRUE.equals(this.section.replaceEmojis())) {
            html = EmojiParser.parseToUnicode((String)html);
        }
        Files.writeString(this.outputPath(), (CharSequence)html, StandardCharsets.UTF_8, new OpenOption[0]);
        logger.info("Written file {}", this.outputPath());
    }

    private void addPrismComponents(HeadTag head, SectionTag section) {
        Pattern pattern = Pattern.compile("<code\\s*class=\"\\s*language-([^\\s\"]+)");
        String html = section.render();
        Matcher matcher = pattern.matcher(html);
        HashSet<CallSite> languages = new HashSet<CallSite>();
        while (matcher.find()) {
            languages.add((CallSite)((Object)("prism." + matcher.group(1))));
        }
        languages.forEach(lang -> CDNResources.js(lang).ifPresent(arg_0 -> ((HeadTag)head).with(arg_0)));
    }
}

