/*
 * Decompiled with CFR 0.152.
 */
package docsite;

import docsite.Docsite;
import docsite.EmitterBuildParams;
import docsite.Script;
import docsite.Section;
import docsite.SectionEmitter;
import docsite.ThemeColors;
import docsite.emitters.CopySectionEmitter;
import docsite.emitters.EmbeddedSiteSectionEmitter;
import docsite.emitters.GeneratedSectionEmitter;
import docsite.emitters.GroupSectionEmitter;
import docsite.emitters.HtmlGeneratedSectionEmitter;
import docsite.emitters.LinkSectionEmitter;
import docsite.emitters.MarkdownGeneratedSectionEmitter;
import docsite.emitters.TemplateSectionEmitter;
import docsite.emitters.TextGeneratedSectionEmitter;
import docsite.util.ImageResolver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SectionEmitterFactory {
    private final EmitterBuildParams buildParams;

    public SectionEmitterFactory(Docsite site, ImageResolver globalImages, ThemeColors themeColors, Path baseDir, Path outputFolder, boolean useCDN, Map<String, String> metadata, List<Script> scripts) {
        this.buildParams = new EmitterBuildParams().site(site).themeColors(themeColors).baseDir(baseDir).outputFolder(outputFolder).globalImages(globalImages).useCDN(useCDN).metadata(metadata).scripts(scripts);
    }

    SectionEmitter createEmitter(Section section) {
        return this.createEmitter(section, null, new ArrayList<SectionEmitter>());
    }

    SectionEmitter createEmitter(Section section, SectionEmitter rootEmitter, List<SectionEmitter> ancestorEmitters) {
        SectionEmitter newEmitter = this.newEmitterInstance(this.buildParams.withRootEmitter(rootEmitter).withSection(section).withAncestorEmitters(ancestorEmitters));
        SectionEmitter newRoot = Objects.requireNonNullElse(rootEmitter, newEmitter);
        ArrayList<SectionEmitter> newAncestors = new ArrayList<SectionEmitter>(ancestorEmitters);
        newAncestors.add(newEmitter);
        for (Section subsection : section.subsections()) {
            newEmitter.addChildEmitter(this.createEmitter(subsection, newRoot, newAncestors));
        }
        return newEmitter;
    }

    private SectionEmitter newEmitterInstance(EmitterBuildParams params) {
        switch (params.section().type()) {
            case copy: {
                return new CopySectionEmitter(params);
            }
            case link: {
                return new LinkSectionEmitter(params);
            }
            case group: {
                return new GroupSectionEmitter(params);
            }
            case embedded: {
                return new EmbeddedSiteSectionEmitter(params);
            }
            case generated: {
                return this.newGeneratedSectionEmitter(params);
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private GeneratedSectionEmitter newGeneratedSectionEmitter(EmitterBuildParams params) {
        if (params.section().template() != null) {
            return new TemplateSectionEmitter(params);
        }
        String source = params.section().source().toLowerCase();
        if (source.endsWith(".md")) {
            return new MarkdownGeneratedSectionEmitter(params);
        }
        if (source.endsWith(".html") || source.endsWith(".htm")) {
            return new HtmlGeneratedSectionEmitter(params);
        }
        return new TextGeneratedSectionEmitter(params);
    }
}

