/*
 * Decompiled with CFR 0.152.
 */
package docsite.emitters;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import docsite.DocsiteException;
import docsite.EmitterBuildParams;
import docsite.emitters.GeneratedSectionEmitter;
import docsite.util.ResourceUtil;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.SectionTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.StreamSupport;

public class MarkdownGeneratedSectionEmitter
extends GeneratedSectionEmitter {
    protected static final DataHolder options = new MutableDataSet().set(TablesExtension.COLUMN_SPANS, (Object)false).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)true).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).set(Parser.EXTENSIONS, List.of(TablesExtension.create())).toImmutable();
    protected static final Parser parser = Parser.builder((DataHolder)options).build();
    protected static final HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();

    public MarkdownGeneratedSectionEmitter(EmitterBuildParams params) {
        super(params);
    }

    @Override
    protected SectionTag createSectionContent() {
        SectionTag sectionTag;
        block8: {
            InputStream markdown = ResourceUtil.open(this.baseDir, this.origin);
            try {
                String markdownContent = ResourceUtil.read(markdown);
                Document document = parser.parse(markdownContent);
                StreamSupport.stream(document.getChildren().spliterator(), false).filter(Heading.class::isInstance).map(Heading.class::cast).forEach(heading -> heading.setAnchorRefId(this.hrefId(heading.getAnchorRefText())));
                String html = renderer.render((Node)document);
                html = this.generateHeadersId(html);
                html = this.normalizeLinks(html);
                html = this.replaceLocalImages(html);
                sectionTag = (SectionTag)((SectionTag)TagCreator.section().with((DomContent)TagCreator.rawHtml((String)html))).withClass("content");
                if (markdown == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (markdown != null) {
                        try {
                            markdown.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DocsiteException(e);
                }
            }
            markdown.close();
        }
        return sectionTag;
    }
}

