/*
 * Decompiled with CFR 0.152.
 */
package docsite.mojo;

import docsite.Docsite;
import docsite.DocsiteEmitter;
import docsite.Logger;
import docsite.Script;
import docsite.ThemeColors;
import docsite.mojo.Autoconfigurer;
import docsite.util.DocsiteReader;
import docsite.util.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(defaultPhase=LifecyclePhase.POST_SITE, name="aggregate")
public class AggregateMojo
extends AbstractMojo {
    @Parameter(name="outputFolder", required=true, defaultValue="${project.build.directory}/docsite", property="docsite.outputFolder")
    File outputFolder;
    @Parameter(name="forceDelete", defaultValue="false", property="docsite.forceDelete")
    boolean forceDelete;
    @Parameter(name="docsite")
    Docsite docsite;
    @Parameter(name="docsiteFile", property="docsite.docsiteFile")
    File docsiteFile;
    @Parameter(name="themeColors")
    ThemeColors themeColors;
    @Parameter(name="metadata")
    Map<String, String> metadata;
    @Parameter(name="scripts")
    Script[] scripts;
    @Parameter(name="cssFile", property="docsite.cssFile")
    File cssFile;
    @Parameter(name="useCDN", defaultValue="true", property="docsite.useCDN")
    boolean useCDN;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.session.getTopLevelProject().equals((Object)this.project)) {
            return;
        }
        this.initializeLogger();
        File[] outputFolderContent = Objects.requireNonNullElse(this.outputFolder.listFiles(), new File[0]);
        try {
            if (this.outputFolder.exists() && outputFolderContent.length > 0) {
                if (this.forceDelete) {
                    Logger.instance().warn("The contents of output folder {} will be deleted", this.outputFolder);
                    ResourceUtil.deleteDirectory(this.outputFolder.toPath());
                } else {
                    Logger.instance().error("As a safety mechanism, the output folder must be empty. You can disable this check using -Ddocsite.forceDelete", new Object[0]);
                    throw new MojoFailureException("The output folder " + this.outputFolder + " is not empty");
                }
            }
            Files.createDirectories(this.outputFolder.toPath(), new FileAttribute[0]);
            this.themeColors = Objects.requireNonNullElse(this.themeColors, ThemeColors.DEFAULT);
            Autoconfigurer autoconfigurer = new Autoconfigurer(this.project);
            ArrayList<MavenProject> children = new ArrayList<MavenProject>();
            for (MavenProject collected : this.session.getProjects()) {
                if (!this.project.equals((Object)collected.getParent())) continue;
                children.add(collected);
            }
            this.docsite = this.docsiteFile != null ? new DocsiteReader().read(this.docsiteFile.toPath()) : autoconfigurer.aggregatedConfiguration(Objects.requireNonNullElse(this.docsite, new Docsite()), children);
            new DocsiteEmitter(this.docsite, this.themeColors, this.cssFile != null ? this.cssFile.toPath() : null, this.useCDN, this.project.getBasedir().toPath(), this.outputFolder.toPath(), this.metadata, this.scripts == null ? List.of() : Arrays.asList(this.scripts)).generateSite();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error generating site", (Throwable)e);
        }
    }

    private void initializeLogger() {
        Logger.initialize(new Logger(arg_0 -> ((Log)this.getLog()).debug(arg_0), arg_0 -> ((Log)this.getLog()).debug(arg_0), arg_0 -> ((Log)this.getLog()).info(arg_0), arg_0 -> ((Log)this.getLog()).warn(arg_0), arg_0 -> ((Log)this.getLog()).error(arg_0)));
    }
}

