/*
 * Decompiled with CFR 0.152.
 */
package docsite.mojo;

import docsite.Docsite;
import docsite.Section;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

public class Autoconfigurer {
    private final MavenProject project;
    private final Path reportingFolder;

    public Autoconfigurer(MavenProject project) {
        this.project = project;
        this.reportingFolder = Path.of(project.getModel().getReporting().getOutputDirectory(), new String[0]);
    }

    public Docsite configuration(Docsite docsite) throws MojoExecutionException {
        docsite.title(Autoconfigurer.nonNull(this.project.getName(), this.project.getArtifactId()));
        docsite.description(Autoconfigurer.nonNull(this.project.getDescription(), ""));
        docsite.index(this.searchIndex());
        docsite.sections(this.createSections());
        return docsite;
    }

    public Docsite aggregatedConfiguration(Docsite docsite, List<MavenProject> children) throws MojoExecutionException {
        docsite.title(Autoconfigurer.nonNull(this.project.getName(), this.project.getArtifactId()));
        docsite.description(Autoconfigurer.nonNull(this.project.getDescription(), ""));
        docsite.index(this.searchIndex());
        ArrayList<Section> sections = new ArrayList<Section>();
        this.changelogSection().ifPresent(sections::add);
        ArrayList<Section> childrenSections = new ArrayList<Section>();
        for (MavenProject child : children) {
            String source = this.project.getBasedir().toPath().relativize(Path.of(child.getBasedir() + "/target/docsite", new String[0])).toString();
            childrenSections.add(Section.copy().source(source).name(child.getName()).siteIndex("index.html").build());
        }
        sections.add(Section.group("Components").icon("fas:stream").subsections(childrenSections).build());
        this.vcsSection().ifPresent(sections::add);
        this.licenseSection().ifPresent(sections::add);
        docsite.sections(sections);
        return docsite;
    }

    @NotNull
    private List<Section> createSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        this.changelogSection().ifPresent(sections::add);
        this.reportsSection().ifPresent(sections::add);
        this.vcsSection().ifPresent(sections::add);
        this.licenseSection().ifPresent(sections::add);
        return sections;
    }

    private String searchIndex() throws MojoExecutionException {
        for (String file : Objects.requireNonNull(this.project.getBasedir().list())) {
            if (!file.toLowerCase().startsWith("readme.") && !file.toLowerCase().startsWith("index.")) continue;
            return file;
        }
        throw new MojoExecutionException("Cannot determine home page for the docsite");
    }

    private Optional<Section> licenseSection() {
        for (String file : Objects.requireNonNull(this.project.getBasedir().list())) {
            if (!file.equalsIgnoreCase("license") && !file.toLowerCase().startsWith("license.")) continue;
            return Optional.of(Section.generated("License").source(file).icon("fas:balance-scale").build());
        }
        return Optional.empty();
    }

    private Optional<Section> changelogSection() {
        for (String file : Objects.requireNonNull(this.project.getBasedir().list())) {
            if (!file.equalsIgnoreCase("changelog") && !file.toLowerCase().startsWith("changelog.")) continue;
            return Optional.of(Section.generated("Changelog").description("Log of modifications on new versions").source(file).icon("fas:clipboard-list").build());
        }
        return Optional.empty();
    }

    private Optional<Section> vcsSection() {
        if (this.project.getScm() != null && this.project.getScm().getUrl() != null) {
            String url = this.project.getScm().getUrl();
            String icon = url.contains("github") ? "fab:github" : (url.contains("gitlab") ? "fab:gitlab" : (url.contains("bitbucket") ? "fab:gitbucket" : (url.contains("git") ? "fab:git-alt" : "fas:code-branch")));
            return Optional.of(Section.link().name("Source").source(url).icon(icon).build());
        }
        return Optional.empty();
    }

    private Optional<Section> reportsSection() {
        ArrayList<Section> reports = new ArrayList<Section>();
        this.mavenPluginSection().ifPresent(reports::add);
        this.javadocSection().ifPresent(reports::add);
        this.dependenciesSection().ifPresent(reports::add);
        this.jacocoSection().ifPresent(reports::add);
        this.surefireSection().ifPresent(reports::add);
        return reports.isEmpty() ? Optional.empty() : Optional.of(Section.group("Reports").description("Collection of technical reports about this project").icon("fas:file-medical-alt").subsections(reports).build());
    }

    private Optional<Section> javadocSection() {
        Path javadocFolder = this.reportingFolder.resolve("apidocs");
        if (Files.exists(javadocFolder, new LinkOption[0])) {
            return Optional.of(Section.site().name("Javadoc").description("Javadoc documentation for this project").source(javadocFolder.toString()).siteIndex("index.html").icon("fab:java").build());
        }
        return Optional.empty();
    }

    private Optional<Section> dependenciesSection() {
        Path dependenciesFile = this.reportingFolder.resolve("dependencies.html");
        if (Files.exists(dependenciesFile, new LinkOption[0])) {
            return Optional.of(Section.generated("Dependencies").description("Collection of artifacts that this project uses").source(dependenciesFile.toString()).replaceEmojis(false).build());
        }
        return Optional.empty();
    }

    private Optional<Section> jacocoSection() {
        Path jacocoFolder = this.reportingFolder.resolve("jacoco");
        if (Files.exists(jacocoFolder, new LinkOption[0])) {
            return Optional.of(Section.site().name("Test Coverage").description("Report of code coverage according the executed tests").source(jacocoFolder.toString()).siteIndex("index.html").build());
        }
        return Optional.empty();
    }

    private Optional<Section> surefireSection() {
        Path report = this.reportingFolder.resolve("surefire-report.html");
        if (Files.exists(report, new LinkOption[0])) {
            return Optional.of(Section.generated("Test Results").description("Results of the automatic tests executed in this project").source(report.toString()).build());
        }
        return Optional.empty();
    }

    private Optional<Section> mavenPluginSection() {
        Path pluginDescriptor = Path.of(this.project.getBuild().getDirectory(), new String[0]).resolve("classes/META-INF/maven/plugin.xml");
        if (Files.exists(pluginDescriptor, new LinkOption[0])) {
            return Optional.of(Section.generated("Plugin Goals").description("Description of goals and available parameters for this plugin").template("maven-plugin-descriptor").source(pluginDescriptor.toString()).build());
        }
        return Optional.empty();
    }

    private static String nonNull(String valueA, String valueB) {
        return valueA == null ? valueB : valueA;
    }
}

