/*
 * Decompiled with CFR 0.152.
 */
package docsite.util;

import docsite.Logger;
import docsite.util.ResourceUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ImageResolver {
    public static final Logger logger = Logger.instance();
    private final Map<String, String> images = new HashMap<String, String>();
    private final Path imageFolder;
    private final Path source;

    public ImageResolver(Path imageFolder, Path source) {
        this.imageFolder = imageFolder;
        this.source = source;
    }

    public ImageResolver(Path imageFolder) {
        this(imageFolder, null);
    }

    public String typeOf(String image) {
        return "image/" + image.substring(image.lastIndexOf(46) + 1);
    }

    public String imageFile(String image) {
        try {
            if (this.source == null) {
                return this.imageFileFromWorkingDir(image);
            }
            return this.imageFileFromRelativeSource(image);
        }
        catch (IOException e) {
            logger.warn("Cannot retrieve image {} : {}", image, e.getMessage());
            logger.debug(e);
            return "";
        }
    }

    private String imageFileFromWorkingDir(String image) throws IOException {
        if (!this.images.containsKey(image)) {
            String extension = image.substring(image.lastIndexOf(46) + 1);
            String id = "image-" + (this.images.size() + 1) + "." + extension;
            String actualFile = this.imageFolder.getParent().relativize(this.imageFolder.resolve(id)).toString();
            ResourceUtil.copyExternalFileWithAnotherName(Path.of(image, new String[0]), this.imageFolder, id);
            this.images.put(image, actualFile);
            return actualFile;
        }
        return this.images.get(image);
    }

    private String imageFileFromRelativeSource(String image) throws IOException {
        if (!this.images.containsKey(image)) {
            String extension = image.substring(image.lastIndexOf(46) + 1);
            String id = "image-" + (this.images.size() + 1) + "." + extension;
            String actualFile = this.imageFolder.getParent().getParent().relativize(this.imageFolder.resolve(id)).toString();
            Path relativeSource = this.source.getParent() == null ? Path.of(image, new String[0]) : this.source.getParent().resolve(image);
            ResourceUtil.copyExternalFileWithAnotherName(relativeSource, this.imageFolder, id);
            this.images.put(image, actualFile);
            return actualFile;
        }
        return this.images.get(image);
    }
}

