/*
 * Decompiled with CFR 0.152.
 */
package docsite.util;

import docsite.DocsiteException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ResourceUtil {
    private static final Map<String, List<String>> STATIC_RESOURCES = Map.of("css", List.of("css/common.css", "font-awesome-all.css", "prism-light.css"), "js", List.of("prism.js"), "webfonts", List.of("fa-brands-400.eot", "fa-brands-400.svg", "fa-brands-400.ttf", "fa-brands-400.woff", "fa-brands-400.woff2", "fa-regular-400.eot", "fa-regular-400.svg", "fa-regular-400.ttf", "fa-regular-400.woff", "fa-regular-400.woff2", "fa-solid-900.eot", "fa-solid-900.svg", "fa-solid-900.ttf", "fa-solid-900.woff", "fa-solid-900.woff2"));

    private ResourceUtil() {
    }

    public static List<String> getResourceFiles(String path) {
        return STATIC_RESOURCES.get(path);
    }

    public static void copyResourceFolder(String folderName, Path outputFolder) throws IOException {
        Path targetFolder = outputFolder.toAbsolutePath().resolve(folderName);
        for (String file : ResourceUtil.getResourceFiles(folderName)) {
            ResourceUtil.copyResource(folderName + "/" + file, targetFolder);
        }
    }

    public static boolean existsResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    public static void copyResource(String resource, Path outputFolder) throws IOException {
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (resourceUrl == null) {
            throw new FileNotFoundException(resource);
        }
        ResourceUtil.copyFromURLToFolder(resourceUrl, outputFolder);
    }

    public static void copyExternalFileWithAnotherName(Path path, Path outputFolder, String newName) throws IOException {
        outputFolder = outputFolder.toAbsolutePath();
        Path target = outputFolder.resolve(newName);
        ResourceUtil.copyFromURL(path.toUri().toURL(), target);
    }

    private static void copyFromURLToFolder(URL url, Path outputFolder) throws IOException {
        outputFolder = outputFolder.toAbsolutePath();
        Path target = outputFolder.resolve(Path.of(url.getFile(), new String[0]).getFileName().toString());
        ResourceUtil.copyFromURL(url, target);
    }

    private static void copyFromURL(URL url, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.copy(url.openStream(), target, StandardCopyOption.REPLACE_EXISTING);
    }

    public static String read(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static InputStream open(Path baseDir, String source) throws IOException {
        try {
            return baseDir.resolve(source).toUri().toURL().openStream();
        }
        catch (MalformedURLException e) {
            return Files.newInputStream(Path.of(source, new String[0]), new OpenOption[0]);
        }
    }

    public static boolean existsSource(Path baseDir, String source) {
        boolean bl;
        block10: {
            if (source == null || source.isBlank()) {
                return false;
            }
            if (Files.exists(baseDir.resolve(source), new LinkOption[0])) {
                return true;
            }
            InputStream stream = new URL(source).openStream();
            try {
                boolean bl2 = bl = stream != null;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static void copyFolder(Path siteFolder, Path outputFolder) {
        try (Stream<Path> walker = Files.walk(siteFolder, new FileVisitOption[0]);){
            Files.createDirectories(outputFolder, new FileAttribute[0]);
            walker.forEach(sourcePath -> {
                try {
                    Path targetPath = outputFolder.resolve(siteFolder.relativize((Path)sourcePath));
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new DocsiteException(e);
                }
            });
        }
        catch (IOException e) {
            throw new DocsiteException(e);
        }
    }

    public static void deleteDirectory(Path path) {
        try (Stream<Path> walker = Files.walk(path, new FileVisitOption[0]);){
            walker.sorted(Comparator.reverseOrder()).forEach(sourcePath -> {
                try {
                    Files.delete(sourcePath);
                }
                catch (IOException e) {
                    throw new DocsiteException(e);
                }
            });
        }
        catch (IOException e) {
            throw new DocsiteException(e);
        }
    }
}

