/*
 * Decompiled with CFR 0.152.
 */
package docsite;

import java.util.Objects;
import java.util.function.Consumer;

public class Logger {
    private static Logger instance;
    private final Consumer<Throwable> debugStackMessager;
    private final Consumer<String> debugMessager;
    private final Consumer<String> infoMessager;
    private final Consumer<String> warnMessager;
    private final Consumer<String> errorMessager;

    public static Logger instance() {
        return Objects.requireNonNull(instance);
    }

    public static void initialize(Logger logger) {
        instance = Objects.requireNonNull(logger);
    }

    public Logger(Consumer<Throwable> debugStackMessager, Consumer<String> debugMessager, Consumer<String> infoMessager, Consumer<String> warnMessager, Consumer<String> errorMessager) {
        this.debugStackMessager = debugStackMessager;
        this.debugMessager = debugMessager;
        this.infoMessager = infoMessager;
        this.warnMessager = warnMessager;
        this.errorMessager = errorMessager;
    }

    public void debug(String message, Object ... args) {
        this.debugMessager.accept(Logger.format(message, args));
    }

    public void debug(Throwable e) {
        this.debugStackMessager.accept(e);
    }

    public void info(String message, Object ... args) {
        this.infoMessager.accept(Logger.format(message, args));
    }

    public void warn(String message, Object ... args) {
        this.warnMessager.accept(Logger.format(message, args));
    }

    public void error(String message, Object ... args) {
        this.errorMessager.accept(Logger.format(message, args));
    }

    private static String format(String message, Object[] args) {
        return String.format(message.replace("{}", "%s"), args);
    }
}

