/*
 * Decompiled with CFR 0.152.
 */
package docsite.emitters;

import docsite.DocsiteException;
import docsite.EmitterBuildParams;
import docsite.emitters.GeneratedSectionEmitter;
import docsite.util.ResourceUtil;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.SectionTag;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;

public class AsciidocGeneratedSectionEmitter
extends GeneratedSectionEmitter {
    private final Asciidoctor asciidoctor = Asciidoctor.Factory.create();
    private final Options options = Options.builder().build();

    public AsciidocGeneratedSectionEmitter(EmitterBuildParams params) {
        super(params);
    }

    @Override
    protected SectionTag generateSectionContent(Tag<?> before) {
        SectionTag sectionTag;
        InputStreamReader reader = new InputStreamReader(ResourceUtil.open(this.baseDir, this.origin()));
        try {
            StringWriter writer = new StringWriter();
            this.asciidoctor.convert((Reader)reader, (Writer)writer, this.options);
            String html = writer.toString();
            html = this.removeH1(html);
            html = this.generateHeadersId(html);
            html = this.normalizeLinks(html);
            html = this.replaceLocalImages(html);
            html = this.replaceMermaidDiagrams(html);
            sectionTag = (SectionTag)((SectionTag)((SectionTag)TagCreator.section().with(before)).with((DomContent)TagCreator.rawHtml((String)html))).withClass("content");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DocsiteException(e);
            }
        }
        ((Reader)reader).close();
        return sectionTag;
    }

    @Override
    protected String replaceMermaidDiagrams(String html) {
        return html.replaceAll("<pre class=\"highlight\"><code class=\"language-mermaid\" data-lang=\"mermaid\">([^<]+)</code></pre>", "<div class=\"mermaid\">$1</div>");
    }
}

