/*
 * Decompiled with CFR 0.152.
 */
package docsite.emitters;

import com.fasterxml.jackson.databind.ObjectMapper;
import docsite.DocsiteException;
import docsite.EmitterBuildParams;
import docsite.emitters.GeneratedSectionEmitter;
import docsite.util.ResourceUtil;
import docsite.util.XmlParser;
import freemarker.core.OutputFormat;
import freemarker.core.PlainTextOutputFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.SectionTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class TemplateSectionEmitter
extends GeneratedSectionEmitter {
    private final Path templatePath;

    public TemplateSectionEmitter(EmitterBuildParams params) {
        super(params);
        this.templatePath = TemplateSectionEmitter.locateTemplate(this.section.template());
    }

    @Override
    protected SectionTag generateSectionContent(Tag<?> before) {
        SectionTag sectionTag;
        StringWriter output = new StringWriter();
        try {
            Configuration cfg = this.markerfreeConfiguration();
            Template template = cfg.getTemplate(this.templatePath.getFileName().toString());
            template.process(this.documentMap(), (Writer)output);
            sectionTag = (SectionTag)((SectionTag)TagCreator.section().with(before)).with((DomContent)TagCreator.rawHtml((String)output.toString()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TemplateException | IOException e) {
                throw new DocsiteException(e);
            }
        }
        output.close();
        return sectionTag;
    }

    @NotNull
    private Configuration markerfreeConfiguration() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
        cfg.setDirectoryForTemplateLoading(this.templatePath.getParent().toFile());
        cfg.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setAutoEscapingPolicy(20);
        cfg.setOutputFormat((OutputFormat)PlainTextOutputFormat.INSTANCE);
        return cfg;
    }

    private Map<String, Object> documentMap() throws IOException {
        String origin = this.origin();
        String extension = origin.substring(origin.indexOf(".") + 1).toLowerCase();
        try (InputStream inputStream = ResourceUtil.open(this.baseDir, origin);){
            switch (extension) {
                case "xml": {
                    Map<String, Object> map = new XmlParser().parse(inputStream);
                    return map;
                }
                case "json": {
                    Map map = (Map)new ObjectMapper().readValue(inputStream, Map.class);
                    return map;
                }
                case "yaml": 
                case "yml": {
                    Map map = (Map)new Yaml().loadAs(inputStream, Map.class);
                    return map;
                }
            }
            throw new IOException("Templating cannot be applied to format of " + origin);
        }
    }

    private static Path locateTemplate(String fromTemplate) {
        String internalTemplate = "templates/" + fromTemplate + ".ftl";
        if (ResourceUtil.existsResource(internalTemplate)) {
            try {
                Path tempFile = Files.createTempDirectory("docsite", new FileAttribute[0]).resolve(internalTemplate);
                ResourceUtil.copyResource(internalTemplate, tempFile.getParent());
                return tempFile;
            }
            catch (IOException e) {
                throw new DocsiteException(e);
            }
        }
        if (!Files.exists(Path.of(fromTemplate, new String[0]), new LinkOption[0])) {
            throw new DocsiteException("Template " + fromTemplate + " is neither an existing file nor a built-in template");
        }
        return Path.of(fromTemplate, new String[0]);
    }
}

