/*
 * Decompiled with CFR 0.152.
 */
package docsite.mojo;

import docsite.Docsite;
import docsite.DocsiteEmitter;
import docsite.Logger;
import docsite.SiteLanguage;
import docsite.ThemeColors;
import docsite.mojo.AbstractMojo;
import docsite.mojo.Autoconfigurer;
import docsite.util.DocsiteReader;
import docsite.util.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(defaultPhase=LifecyclePhase.POST_SITE, name="aggregate")
public class AggregateMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.session.getTopLevelProject().equals((Object)this.project)) {
            return;
        }
        DocsiteReader docsiteReader = new DocsiteReader();
        this.initializeLogger();
        File[] outputFolderContent = Objects.requireNonNullElse(this.outputFolder.listFiles(), new File[0]);
        try {
            if (this.outputFolder.exists() && outputFolderContent.length > 0) {
                if (this.forceDelete) {
                    Logger.instance().warn("The contents of output folder {} will be deleted", this.outputFolder);
                    ResourceUtil.deleteDirectory(this.outputFolder.toPath());
                } else {
                    Logger.instance().error("As a safety mechanism, the output folder must be empty. You can disable this check using -Ddocsite.forceDelete", new Object[0]);
                    throw new MojoFailureException("The output folder " + this.outputFolder + " is not empty");
                }
            }
            Files.createDirectories(this.outputFolder.toPath(), new FileAttribute[0]);
            this.themeColors = Objects.requireNonNullElse(this.themeColors, ThemeColors.DEFAULT);
            Autoconfigurer autoconfigurer = new Autoconfigurer(this.project);
            ArrayList<MavenProject> children = new ArrayList<MavenProject>();
            for (MavenProject collected : this.session.getProjects()) {
                if (!this.project.equals((Object)collected.getParent())) continue;
                children.add(collected);
            }
            this.docsite = this.docsiteFile != null ? docsiteReader.read(this.docsiteFile.toPath()) : autoconfigurer.aggregatedConfiguration(Objects.requireNonNullElse(this.docsite, new Docsite()), children);
            Map<String, Map<String, String>> localization = this.getLocalization();
            if (this.localizations == null && this.localizationFile != null && Files.exists(this.localizationFile.toPath(), new LinkOption[0])) {
                localization = docsiteReader.readLocalization(this.localizationFile.toPath());
            }
            new DocsiteEmitter(this.docsite, this.themeColors, this.cssFile != null ? this.cssFile.toPath() : null, this.useCDN, this.project.getBasedir().toPath(), this.outputFolder.toPath(), this.metadata, this.scripts == null ? List.of() : Arrays.asList(this.scripts), SiteLanguage.of(this.languages), localization).generateSite();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error generating site", (Throwable)e);
        }
    }

    private void initializeLogger() {
        Logger.initialize(new Logger(arg_0 -> ((Log)this.getLog()).debug(arg_0), arg_0 -> ((Log)this.getLog()).debug(arg_0), arg_0 -> ((Log)this.getLog()).info(arg_0), arg_0 -> ((Log)this.getLog()).warn(arg_0), arg_0 -> ((Log)this.getLog()).error(arg_0)));
    }
}

