/*
 * Decompiled with CFR 0.152.
 */
package docsite.util;

import docsite.Section;
import docsite.SiteLanguage;
import docsite.util.ImageResolver;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ITag;
import j2html.tags.specialized.ImgTag;
import j2html.tags.specialized.LinkTag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmitterUtil {
    private static Pattern faPattern = Pattern.compile("(fa.?):([^:]+)");

    private EmitterUtil() {
    }

    public static ATag internalLink(String title, String url) {
        return (ATag)((ATag)TagCreator.a((String)title).withClass("internal")).withHref(url);
    }

    public static ATag internalLinkWithIcon(Path baseDir, String title, String url, String icon, ImageResolver images) {
        return (ATag)((ATag)((ATag)TagCreator.a().withClasses(new String[]{"label internal"})).withHref(url)).with(new DomContent[]{EmitterUtil.icon(baseDir, icon, images), TagCreator.span((String)title)});
    }

    public static ATag externalLinkWithIcon(Path baseDir, String title, String url, String icon, ImageResolver images) {
        return (ATag)((ATag)((ATag)((ATag)((ATag)TagCreator.a().withClasses(new String[]{"label external"})).withHref(url)).withTarget("_blank")).withRel("external noreferrer noopener nofollow")).with(new DomContent[]{EmitterUtil.icon(baseDir, icon, images), TagCreator.span((String)title)});
    }

    public static ATag externalLinkWithImage(Path baseDir, String title, String url, String icon, ImageResolver images) {
        return (ATag)((ATag)((ATag)((ATag)((ATag)TagCreator.a().withClasses(new String[]{"label external"})).withHref(url)).withTarget("_blank")).withRel("external noreferrer noopener nofollow")).with(new DomContent[]{EmitterUtil.image(baseDir, icon, images), TagCreator.span((String)title)});
    }

    public static ITag icon(Path baseDir, String icon, ImageResolver images) {
        if (icon == null || icon.isBlank()) {
            return (ITag)TagCreator.i().withClass("hidden");
        }
        Matcher faMatcher = faPattern.matcher(icon);
        if (faMatcher.matches()) {
            return (ITag)TagCreator.i().withClasses(new String[]{faMatcher.group(1) + " fa-" + faMatcher.group(2)});
        }
        if (Files.exists(baseDir.resolve(icon), new LinkOption[0])) {
            return (ITag)((ITag)TagCreator.i().withClass("external-icon")).withStyle("background-image: url('" + images.imageFile(icon) + "')");
        }
        return (ITag)((ITag)TagCreator.i().withClass("external-icon")).withStyle("background-image: url('" + icon + "')");
    }

    public static ImgTag image(Path baseDir, String source, ImageResolver images) {
        if (source == null || source.isBlank()) {
            return (ImgTag)TagCreator.img().withClass("hidden");
        }
        if (Files.exists(baseDir.resolve(source), new LinkOption[0])) {
            return (ImgTag)TagCreator.img().withSrc(images.imageFile(source));
        }
        return (ImgTag)TagCreator.img().withSrc(source);
    }

    public static ATag externalLink(String title, String url) {
        return (ATag)((ATag)((ATag)((ATag)TagCreator.a((String)title).withClass("external")).withHref(url)).withTarget("_blank")).withRel("external noreferrer noopener nofollow");
    }

    public static String href(String name) {
        return name.strip().toLowerCase().replace(" ", "-");
    }

    public static String href(Section section) {
        if (section.type() == Section.SectionType.embedded) {
            return EmitterUtil.href(section.name() + "/" + section.siteIndex());
        }
        return EmitterUtil.href(section.name());
    }

    public static String page(String name) {
        return EmitterUtil.href(name) + ".html";
    }

    public static String page(String name, SiteLanguage language) {
        return language.isPrimary() ? EmitterUtil.page(name) : EmitterUtil.href(name) + "_" + language.language() + ".html";
    }

    public static LinkTag stylesheet(String href) {
        return (LinkTag)((LinkTag)TagCreator.link().attr("href", (Object)href)).attr("rel", (Object)"stylesheet");
    }

    public static String withLanguage(SiteLanguage language, String path) {
        if (language.isPrimary()) {
            return path;
        }
        int extensionPosition = path.lastIndexOf(46);
        if (extensionPosition == -1) {
            return path + "_" + language.language();
        }
        return path.substring(0, extensionPosition) + "_" + language.language() + path.substring(extensionPosition);
    }
}

