/*
 * Decompiled with CFR 0.152.
 */
package imconfig;

import imconfig.AnnotatedConfiguration;
import imconfig.ConfigurationException;
import imconfig.ConfigurationFactory;
import imconfig.PropertyDefinition;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public interface Configuration {
    public static ConfigurationFactory factory() {
        return ConfigurationFactory.instance();
    }

    public Configuration withPrefix(String var1);

    public Configuration filtered(String var1);

    public Configuration inner(String var1);

    public boolean isEmpty();

    public boolean hasProperty(String var1);

    public Iterable<String> keys();

    public Iterator<String> keyIterator();

    public Stream<String> keyStream();

    public <T> Optional<T> get(String var1, Class<T> var2);

    public <T> List<T> getList(String var1, Class<T> var2);

    public <T> Set<T> getSet(String var1, Class<T> var2);

    public <T> Stream<T> getStream(String var1, Class<T> var2);

    public Properties asProperties();

    public Map<String, String> asMap();

    public void forEach(BiConsumer<String, String> var1);

    public Configuration appendFromAnnotation(Class<?> var1);

    public Configuration appendFromAnnotation(AnnotatedConfiguration var1);

    public Configuration appendFromEnvironment();

    public Configuration appendFromSystem();

    public Configuration appendFromPath(Path var1);

    public Configuration appendFromURI(URI var1);

    public Configuration appendFromProperties(Properties var1);

    public Configuration appendFromMap(Map<String, ?> var1);

    public Configuration appendFromResource(String var1, ClassLoader var2);

    public Configuration append(Configuration var1);

    public Configuration appendProperty(String var1, String var2);

    default public Configuration appendFromPairs(String ... pairs) {
        return this.append(ConfigurationFactory.instance().fromPairs(pairs));
    }

    public boolean hasDefinition(String var1);

    public List<String> validations(String var1);

    public Optional<PropertyDefinition> getDefinition(String var1);

    public Map<String, PropertyDefinition> getDefinitions();

    public Map<String, List<String>> validations();

    public Configuration validate() throws ConfigurationException;

    public Configuration accordingDefinitions(Collection<PropertyDefinition> var1);

    public Configuration accordingDefinitionsFromPath(Path var1);

    public Configuration accordingDefinitionsFromURI(URI var1);

    public Configuration accordingDefinitionsFromResource(String var1, ClassLoader var2);

    public String getDefinitionsToString();
}

