/*
 * Decompiled with CFR 0.152.
 */
package imconfig;

import imconfig.AnnotatedConfiguration;
import imconfig.Configuration;
import imconfig.ConfigurationException;
import imconfig.PropertyDefinition;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;

public interface ConfigurationFactory {
    public static ConfigurationFactory instance() {
        try {
            return ServiceLoader.load(ConfigurationFactory.class).stream().findFirst().orElseThrow().type().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationException(e);
        }
    }

    public ConfigurationFactory multivalueSeparator(char var1);

    public boolean hasMultivalueSeparator();

    public char multivalueSeparator();

    public Configuration merge(Configuration var1, Configuration var2);

    public Configuration empty();

    public Configuration fromAnnotation(Class<?> var1);

    public Configuration fromAnnotation(AnnotatedConfiguration var1);

    public Configuration fromEnvironment();

    public Configuration fromSystem();

    public Configuration fromPath(Path var1);

    public Configuration fromURI(URI var1);

    public Configuration fromResource(String var1, ClassLoader var2);

    public Configuration fromProperties(Properties var1);

    public Configuration fromMap(Map<String, ?> var1);

    default public Configuration fromPairs(String ... pairs) {
        if (pairs.length % 2 == 1) {
            throw new IllegalArgumentException("Number of arguments must be even");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < pairs.length; i += 2) {
            map.put(pairs[i], pairs[i + 1]);
        }
        return this.fromMap(map);
    }

    public Configuration accordingDefinitions(Collection<PropertyDefinition> var1);

    public Configuration accordingDefinitionsFromPath(Path var1);

    public Configuration accordingDefinitionsFromURI(URI var1);

    public Configuration accordingDefinitionsFromResource(String var1, ClassLoader var2);
}

