/*
 * Decompiled with CFR 0.152.
 */
package imconfig;

import imconfig.PropertyDefinitionBuilder;
import imconfig.PropertyType;
import java.util.Optional;

public class PropertyDefinition {
    private final String property;
    private final String description;
    private final boolean required;
    private final boolean multivalue;
    private final String defaultValue;
    private final PropertyType propertyType;

    public static PropertyDefinitionBuilder builder() {
        return new PropertyDefinitionBuilder();
    }

    public static PropertyDefinitionBuilder builder(String property) {
        return new PropertyDefinitionBuilder().property(property);
    }

    PropertyDefinition(String property, String description, boolean required, boolean multivalue, String defaultValue, PropertyType type) {
        this.property = property;
        this.description = description == null ? "" : description;
        this.defaultValue = defaultValue;
        this.multivalue = multivalue;
        this.required = required;
        this.propertyType = type;
    }

    public String property() {
        return this.property;
    }

    public String description() {
        return this.description;
    }

    public boolean required() {
        return this.required;
    }

    public Optional<String> defaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public String type() {
        return this.propertyType.name();
    }

    public boolean multivalue() {
        return this.multivalue;
    }

    public String hint() {
        return String.format("%s%s%s", this.propertyType.hint(), this.defaultValue != null ? " [default: " + this.defaultValue + "]" : "", this.required ? " (required)" : "");
    }

    public Optional<String> validate(String value) {
        if (value == null || value.isBlank()) {
            if (this.required) {
                return Optional.of("Property is required but not present");
            }
        } else if (!this.propertyType.accepts(value)) {
            return Optional.of("Invalid value '" + value + "', expected: " + this.hint());
        }
        return Optional.empty();
    }

    public String toString() {
        String hint = this.multivalue ? "List of " + this.hint().substring(0, 1).toLowerCase() + this.hint().substring(1) : this.hint();
        return String.format("- %s: %s%s", this.property, this.description.isBlank() ? hint : this.description, this.description.isBlank() ? "" : "\n  " + hint);
    }
}

