/*
 * Decompiled with CFR 0.152.
 */
package imconfig;

import imconfig.PropertyDefinition;
import imconfig.PropertyType;
import imconfig.types.BooleanPropertyType;
import imconfig.types.DecimalPropertyType;
import imconfig.types.EnumPropertyType;
import imconfig.types.IntegerPropertyType;
import imconfig.types.TextPropertyType;
import java.util.List;
import java.util.Objects;

public class PropertyDefinitionBuilder {
    private String property;
    private String description;
    private boolean required;
    private boolean multivalue;
    private String defaultValue;
    private PropertyType propertyType;

    public PropertyDefinitionBuilder property(String property) {
        this.property = property;
        return this;
    }

    public PropertyDefinitionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PropertyDefinitionBuilder required() {
        this.required = true;
        return this;
    }

    public PropertyDefinitionBuilder required(Boolean required) {
        this.required = Boolean.TRUE.equals(required);
        return this;
    }

    public PropertyDefinitionBuilder multivalue() {
        this.multivalue = true;
        return this;
    }

    public PropertyDefinitionBuilder multivalue(Boolean multivalue) {
        this.multivalue = Boolean.TRUE.equals(multivalue);
        return this;
    }

    public PropertyDefinitionBuilder defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public PropertyDefinitionBuilder textType(String pattern) {
        this.propertyType = new TextPropertyType(pattern);
        return this;
    }

    public PropertyDefinitionBuilder textType() {
        return this.textType(null);
    }

    public PropertyDefinitionBuilder integerType(Number min, Number max) {
        this.propertyType = new IntegerPropertyType(min, max);
        return this;
    }

    public PropertyDefinitionBuilder integerType() {
        return this.integerType(null, null);
    }

    public PropertyDefinitionBuilder decimalType(Number min, Number max) {
        this.propertyType = new DecimalPropertyType(min, max);
        return this;
    }

    public PropertyDefinitionBuilder decimalType() {
        return this.decimalType(null, null);
    }

    public PropertyDefinitionBuilder enumType(String ... values) {
        this.propertyType = new EnumPropertyType(List.of(values));
        return this;
    }

    public PropertyDefinitionBuilder booleanType() {
        this.propertyType = new BooleanPropertyType();
        return this;
    }

    public PropertyDefinitionBuilder propertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    public PropertyDefinition build() {
        Objects.requireNonNull(this.property);
        Objects.requireNonNull(this.propertyType);
        return new PropertyDefinition(this.property, this.description, this.required, this.multivalue, this.defaultValue, this.propertyType);
    }
}

