/*
 * Decompiled with CFR 0.152.
 */
package imconfig.internal;

import imconfig.AnnotatedConfiguration;
import imconfig.Configuration;
import imconfig.ConfigurationException;
import imconfig.ConfigurationFactory;
import imconfig.PropertyDefinition;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractConfiguration
implements Configuration {
    protected final ConfigurationFactory builder;
    protected final Map<String, PropertyDefinition> definitions;

    protected AbstractConfiguration(ConfigurationFactory builder, Map<String, PropertyDefinition> definitions) {
        this.builder = builder;
        this.definitions = definitions;
    }

    @Override
    public Configuration append(Configuration otherConfiguration) {
        return this.builder.merge(this, otherConfiguration);
    }

    @Override
    public Configuration appendFromAnnotation(Class<?> configuredClass) {
        return this.builder.merge(this, this.builder.fromAnnotation(configuredClass));
    }

    @Override
    public Configuration appendFromAnnotation(AnnotatedConfiguration annotation) {
        return this.builder.merge(this, this.builder.fromAnnotation(annotation));
    }

    @Override
    public Configuration appendFromResource(String resourcePath, ClassLoader classLoader) {
        return this.builder.merge(this, this.builder.fromResource(resourcePath, classLoader));
    }

    @Override
    public Configuration appendFromEnvironment() {
        return this.builder.merge(this, this.builder.fromEnvironment());
    }

    @Override
    public Configuration appendFromSystem() {
        return this.builder.merge(this, this.builder.fromSystem());
    }

    @Override
    public Configuration appendFromMap(Map<String, ?> propertyMap) {
        return this.builder.merge(this, this.builder.fromMap(propertyMap));
    }

    @Override
    public Configuration appendFromPath(Path path) {
        return this.builder.merge(this, this.builder.fromPath(path));
    }

    @Override
    public Configuration appendFromProperties(Properties properties) {
        return this.builder.merge(this, this.builder.fromProperties(properties));
    }

    @Override
    public Configuration appendFromURI(URI uri) {
        return this.builder.merge(this, this.builder.fromURI(uri));
    }

    @Override
    public Configuration appendProperty(String property, String value) {
        HashMap<String, String> singlePropertyMap = new HashMap<String, String>();
        singlePropertyMap.put(property, value);
        return this.builder.merge(this, this.builder.fromMap(singlePropertyMap));
    }

    @Override
    public Map<String, PropertyDefinition> getDefinitions() {
        return Collections.unmodifiableMap(this.definitions);
    }

    @Override
    public Optional<PropertyDefinition> getDefinition(String key) {
        return Optional.ofNullable(this.definitions.get(key));
    }

    @Override
    public boolean hasDefinition(String key) {
        return this.definitions.containsKey(key);
    }

    @Override
    public List<String> validations(String key) {
        return this.getDefinition(key).map(definition -> this.validations(key, (PropertyDefinition)definition)).orElseGet(List::of);
    }

    private List<String> validations(String key, PropertyDefinition definition) {
        List values = definition.multivalue() ? this.getList(key, String.class) : this.get(key, String.class).map(List::of).orElseGet(List::of);
        return values.stream().map(definition::validate).flatMap(Optional::stream).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<String>> validations() {
        Stream<Map.Entry> invalidValues = this.keyStream().map(key -> Map.entry(key, this.validations((String)key))).filter(entry -> !((List)entry.getValue()).isEmpty());
        Stream<Map.Entry> missingValues = this.definitions.values().stream().filter(PropertyDefinition::required).filter(it -> !this.hasProperty(it.property())).map(it -> Map.entry(it.property(), it.validate(null).map(List::of).orElseGet(List::of)));
        return Stream.concat(invalidValues, missingValues).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Configuration validate() {
        Map<String, List<String>> validations = this.validations();
        if (!validations.isEmpty()) {
            String message = validations.entrySet().stream().map(entry -> String.format("%s : %s", entry.getKey(), String.join((CharSequence)("\n" + " ".repeat(((String)entry.getKey()).length() + 3)), (Iterable)entry.getValue()))).collect(Collectors.joining("\n\t", "The configuration contains one or more invalid values:\n\t", ""));
            throw new ConfigurationException(message);
        }
        return this;
    }

    @Override
    public Configuration accordingDefinitions(Collection<PropertyDefinition> definitions) {
        return this.builder.merge(this, this.builder.accordingDefinitions(definitions));
    }

    @Override
    public Configuration accordingDefinitionsFromPath(Path path) {
        return this.builder.merge(this, this.builder.accordingDefinitionsFromPath(path));
    }

    @Override
    public Configuration accordingDefinitionsFromURI(URI uri) {
        return this.builder.merge(this, this.builder.accordingDefinitionsFromURI(uri));
    }

    @Override
    public Configuration accordingDefinitionsFromResource(String resource, ClassLoader classLoader) {
        return this.builder.merge(this, this.builder.accordingDefinitionsFromResource(resource, classLoader));
    }

    @Override
    public String getDefinitionsToString() {
        return this.getDefinitions().values().stream().map(PropertyDefinition::toString).collect(Collectors.joining("\n"));
    }
}

