/*
 * Decompiled with CFR 0.152.
 */
package imconfig.internal;

import imconfig.Configuration;
import imconfig.ConfigurationFactory;
import imconfig.PropertyDefinition;
import imconfig.internal.AbstractConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;

public class ApacheConfiguration2
extends AbstractConfiguration {
    protected final org.apache.commons.configuration2.Configuration conf;

    protected ApacheConfiguration2(ConfigurationFactory builder, Map<String, PropertyDefinition> definitions, org.apache.commons.configuration2.Configuration conf) {
        super(builder, definitions);
        this.conf = conf;
    }

    protected ApacheConfiguration2(ConfigurationFactory builder, org.apache.commons.configuration2.Configuration conf) {
        super(builder, Map.of());
        this.conf = conf;
    }

    @Override
    public Configuration withPrefix(String keyPrefix) {
        BaseConfiguration innerConf = this.prepare(new BaseConfiguration());
        this.conf.getKeys().forEachRemaining(key -> innerConf.addProperty(keyPrefix + "." + key, this.conf.getProperty(key)));
        return new ApacheConfiguration2(this.builder, this.definitions, (org.apache.commons.configuration2.Configuration)innerConf);
    }

    @Override
    public Configuration filtered(String keyPrefix) {
        BaseConfiguration innerConf = this.prepare(new BaseConfiguration());
        this.conf.getKeys(keyPrefix).forEachRemaining(key -> {
            if (key.startsWith(keyPrefix)) {
                innerConf.addProperty(key, this.conf.getProperty(key));
            }
        });
        return new ApacheConfiguration2(this.builder, this.definitions, (org.apache.commons.configuration2.Configuration)innerConf);
    }

    @Override
    public Configuration inner(String keyPrefix) {
        if (keyPrefix == null || keyPrefix.isEmpty()) {
            return this;
        }
        return new ApacheConfiguration2(this.builder, this.definitions, this.conf.subset(keyPrefix));
    }

    @Override
    public boolean isEmpty() {
        return this.conf.isEmpty();
    }

    @Override
    public boolean hasProperty(String key) {
        return this.conf.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.keyList();
    }

    @Override
    public Iterator<String> keyIterator() {
        return this.conf.getKeys();
    }

    @Override
    public Stream<String> keyStream() {
        return this.keyList().stream();
    }

    private List<String> keyList() {
        ArrayList<String> keys = new ArrayList<String>();
        this.conf.getKeys().forEachRemaining(keys::add);
        return keys;
    }

    @Override
    public <T> Optional<T> get(String key, Class<T> type) {
        boolean empty;
        PropertyDefinition definition = (PropertyDefinition)this.definitions.get(key);
        String raw = this.conf.getString(key);
        boolean bl = empty = raw == null || "".equals(raw);
        if (definition != null) {
            String value;
            String string = value = empty ? (String)definition.defaultValue().orElse(null) : raw;
            if (value != null) {
                return Optional.of(this.convert(value, type));
            }
            return Optional.empty();
        }
        return Optional.ofNullable(empty ? null : this.conf.get(type, key));
    }

    @Override
    public <T> List<T> getList(String key, Class<T> type) {
        return Optional.ofNullable(this.conf.getList(type, key)).orElse(Collections.emptyList());
    }

    @Override
    public <T> Set<T> getSet(String key, Class<T> type) {
        return new HashSet<T>(this.getList(key, type));
    }

    @Override
    public <T> Stream<T> getStream(String key, Class<T> type) {
        return this.getList(key, type).stream();
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        this.conf.getKeys().forEachRemaining(key -> properties.put(key, this.conf.getString(key)));
        return properties;
    }

    @Override
    public Map<String, String> asMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.conf.getKeys().forEachRemaining(key -> map.put((String)key, this.conf.getString(key)));
        return map;
    }

    public String toString() {
        StringBuilder string = new StringBuilder("configuration:\n---------------\n");
        this.conf.getKeys().forEachRemaining(key -> {
            Object[] values = this.conf.getStringArray(key);
            String value = "<undefined>";
            if (values.length == 1) {
                value = values[0];
            } else if (values.length > 1) {
                value = Arrays.toString(values);
            }
            string.append((String)key).append(" : ").append(value).append("\n");
        });
        return string.append("---------------").toString();
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        this.conf.getKeys().forEachRemaining(key -> consumer.accept((String)key, (String)this.conf.get(String.class, key)));
    }

    private <T> T convert(String raw, Class<T> type) {
        org.apache.commons.configuration2.AbstractConfiguration abstractConf = (org.apache.commons.configuration2.AbstractConfiguration)this.conf;
        return (T)abstractConf.getConversionHandler().to((Object)raw, type, abstractConf.getInterpolator());
    }

    private <T extends org.apache.commons.configuration2.AbstractConfiguration> T prepare(T abstractConfiguration) {
        if (this.builder.hasMultivalueSeparator()) {
            abstractConfiguration.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(this.builder.multivalueSeparator()));
        }
        return abstractConfiguration;
    }
}

