/*
 * Decompiled with CFR 0.152.
 */
package imconfig.internal;

import imconfig.AnnotatedConfiguration;
import imconfig.Configuration;
import imconfig.ConfigurationException;
import imconfig.ConfigurationFactory;
import imconfig.Property;
import imconfig.PropertyDefinition;
import imconfig.internal.ApacheConfiguration2;
import imconfig.internal.ApacheConfiguration2ConversionHandler;
import imconfig.internal.ClasspathURLStreamHandler;
import imconfig.internal.PropertyDefinitionParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.configuration2.JSONConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;

public class ApacheConfiguration2Factory
implements ConfigurationFactory {
    private final ConversionHandler conversionHandler = new ApacheConfiguration2ConversionHandler();
    private final PropertyDefinitionParser parser = new PropertyDefinitionParser();
    private char separator = '\u0000';

    @Override
    public ConfigurationFactory multivalueSeparator(char separator) {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("Invalid separator symbol: " + separator);
        }
        this.separator = separator;
        return this;
    }

    @Override
    public boolean hasMultivalueSeparator() {
        return this.separator != '\u0000';
    }

    @Override
    public char multivalueSeparator() {
        return this.separator;
    }

    @Override
    public Configuration merge(Configuration base, Configuration delta) {
        BaseConfiguration result = new BaseConfiguration();
        for (String property : delta.keys()) {
            List<String> existing = base.getList(property, String.class);
            List<String> added = delta.getList(property, String.class);
            if (existing.isEmpty() && added.isEmpty()) {
                result.setProperty(property, (Object)"");
                continue;
            }
            if (added.isEmpty()) continue;
            added.forEach(arg_0 -> ApacheConfiguration2Factory.lambda$merge$0((AbstractConfiguration)result, property, arg_0));
        }
        for (String property : base.keys()) {
            if (result.containsKey(property)) continue;
            base.getList(property, String.class).forEach(arg_0 -> ApacheConfiguration2Factory.lambda$merge$1((AbstractConfiguration)result, property, arg_0));
        }
        HashMap<String, PropertyDefinition> definitions = new HashMap<String, PropertyDefinition>(base.getDefinitions());
        definitions.putAll(delta.getDefinitions());
        return new ApacheConfiguration2(this, definitions, (org.apache.commons.configuration2.Configuration)result);
    }

    @Override
    public Configuration empty() {
        return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)new BaseConfiguration());
    }

    @Override
    public Configuration fromAnnotation(Class<?> configuredClass) {
        return Optional.ofNullable(configuredClass.getAnnotation(AnnotatedConfiguration.class)).map(this::fromAnnotation).orElseThrow(() -> new ConfigurationException(configuredClass + " is not annotated with @Configurator"));
    }

    @Override
    public Configuration fromAnnotation(AnnotatedConfiguration annotation) {
        BaseConfiguration configuration = this.configure(new BaseConfiguration());
        for (Property property : annotation.value()) {
            String[] value = property.value();
            if (value.length == 1) {
                configuration.addProperty(property.key(), (Object)value[0]);
                continue;
            }
            configuration.addProperty(property.key(), (Object)value);
        }
        return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)configuration);
    }

    @Override
    public Configuration fromEnvironment() {
        return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)new EnvironmentConfiguration());
    }

    @Override
    public Configuration fromSystem() {
        return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)new SystemConfiguration());
    }

    @Override
    public Configuration fromPath(Path path) {
        return this.fromURI(path.toUri());
    }

    @Override
    public Configuration fromProperties(Properties properties) {
        BaseConfiguration configuration = this.configure(new BaseConfiguration());
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            configuration.addProperty(property.getKey().toString(), property.getValue());
        }
        return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)configuration);
    }

    @Override
    public Configuration fromMap(Map<String, ?> properties) {
        BaseConfiguration configuration = this.configure(new BaseConfiguration());
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            configuration.addProperty(property.getKey(), property.getValue());
        }
        return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)configuration);
    }

    private Configuration fromMap(Map<String, ?> properties, Collection<PropertyDefinition> definitions) {
        BaseConfiguration configuration = this.configure(new BaseConfiguration());
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            configuration.addProperty(property.getKey(), property.getValue());
        }
        Map<String, PropertyDefinition> definitionMap = definitions.stream().collect(Collectors.toMap(PropertyDefinition::property, x -> x));
        return new ApacheConfiguration2(this, definitionMap, (org.apache.commons.configuration2.Configuration)configuration);
    }

    @Override
    public Configuration fromURI(URI uri) {
        return this.fromURI(uri, null);
    }

    @Override
    public Configuration fromResource(String resource, ClassLoader classLoader) {
        return this.fromURI(URI.create("classpath:///" + resource), classLoader);
    }

    private Configuration fromURI(URI uri, ClassLoader classLoader) {
        try {
            return this.buildFromURL(this.adaptURI(uri, classLoader));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public Configuration accordingDefinitions(Collection<PropertyDefinition> definitions) {
        Map<String, String> defaultValues = definitions.stream().filter(definition -> definition.defaultValue().isPresent()).collect(Collectors.toMap(PropertyDefinition::property, definition -> definition.defaultValue().orElseThrow()));
        return this.fromMap(defaultValues, definitions);
    }

    @Override
    public Configuration accordingDefinitionsFromURI(URI uri) {
        return this.accordingDefinitionsFromURI(uri, null);
    }

    private Configuration accordingDefinitionsFromURI(URI uri, ClassLoader classLoader) {
        Configuration configuration;
        block8: {
            InputStream inputStream = this.adaptURI(uri, classLoader).openStream();
            try {
                configuration = this.accordingDefinitions(this.parser.read(inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
            inputStream.close();
        }
        return configuration;
    }

    @Override
    public Configuration accordingDefinitionsFromPath(Path path) {
        return this.accordingDefinitionsFromURI(path.toUri());
    }

    @Override
    public Configuration accordingDefinitionsFromResource(String resource, ClassLoader classLoader) {
        return this.accordingDefinitionsFromURI(URI.create("classpath:///" + resource), classLoader);
    }

    private Configuration buildFromURL(URL url) {
        Configuration configuration;
        String file = url.getFile();
        if (file.endsWith(".properties")) {
            configuration = this.buildFromPropertiesFile(url);
        } else if (file.endsWith(".json")) {
            configuration = this.buildFromJSON(url);
        } else if (file.endsWith(".xml")) {
            configuration = this.buildFromXML(url);
        } else if (file.endsWith(".yaml")) {
            configuration = this.buildFromYAML(url);
        } else {
            throw new ConfigurationException("Cannot determine resource type of " + url);
        }
        return configuration;
    }

    private Configuration buildFromJSON(URL url) {
        ApacheConfiguration2 apacheConfiguration2;
        block8: {
            InputStream stream = url.openStream();
            try {
                JSONConfiguration json = this.configure(new JSONConfiguration());
                json.read(stream);
                apacheConfiguration2 = new ApacheConfiguration2(this, Map.of(), (org.apache.commons.configuration2.Configuration)json);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | org.apache.commons.configuration2.ex.ConfigurationException e) {
                    throw new ConfigurationException(e);
                }
            }
            stream.close();
        }
        return apacheConfiguration2;
    }

    private Configuration buildFromYAML(URL url) {
        ApacheConfiguration2 apacheConfiguration2;
        block8: {
            InputStream stream = url.openStream();
            try {
                YAMLConfiguration yaml = this.configure(new YAMLConfiguration());
                yaml.read(stream);
                apacheConfiguration2 = new ApacheConfiguration2(this, Map.of(), (org.apache.commons.configuration2.Configuration)yaml);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | org.apache.commons.configuration2.ex.ConfigurationException e) {
                    throw new ConfigurationException(e);
                }
            }
            stream.close();
        }
        return apacheConfiguration2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Configuration buildFromPropertiesFile(URL url) {
        try (InputStream stream = url.openStream();){
            ApacheConfiguration2 apacheConfiguration2;
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                PropertiesConfiguration properties = this.configure(new PropertiesConfiguration());
                properties.read((Reader)reader);
                apacheConfiguration2 = new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)properties);
            }
            return apacheConfiguration2;
        }
        catch (IOException | org.apache.commons.configuration2.ex.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    private Configuration buildFromXML(URL url) {
        try {
            Configurations configurations = new Configurations();
            XMLConfiguration xml = this.configure(configurations.xml(url));
            return new ApacheConfiguration2((ConfigurationFactory)this, (org.apache.commons.configuration2.Configuration)xml);
        }
        catch (org.apache.commons.configuration2.ex.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    private <T extends AbstractConfiguration> T configure(T configuration) {
        configuration.setConversionHandler(this.conversionHandler);
        if (this.hasMultivalueSeparator()) {
            configuration.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(this.multivalueSeparator()));
        }
        return configuration;
    }

    private URL adaptURI(URI uri, ClassLoader classLoader) throws MalformedURLException {
        if ("classpath".equals(uri.getScheme())) {
            return new URL("classpath", null, -1, uri.getPath(), new ClasspathURLStreamHandler(classLoader));
        }
        return uri.toURL();
    }

    private static /* synthetic */ void lambda$merge$1(AbstractConfiguration result, String property, String value) {
        result.addProperty(property, (Object)value);
    }

    private static /* synthetic */ void lambda$merge$0(AbstractConfiguration result, String property, String value) {
        result.addProperty(property, (Object)value);
    }
}

