/*
 * Decompiled with CFR 0.152.
 */
package imconfig.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Objects;

public class ClasspathURLStreamHandler
extends URLStreamHandler {
    private final ClassLoader classLoader;

    public ClasspathURLStreamHandler(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "A class loader is required for 'classpath:' schema");
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URL resourceUrl;
        String path = url.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((resourceUrl = this.classLoader.getResource(path)) == null) {
            throw new FileNotFoundException("Cannot access to classpath resource " + url);
        }
        return resourceUrl.openConnection();
    }
}

