/*
 * Decompiled with CFR 0.152.
 */
package imconfig.internal;

import imconfig.ConfigurationException;
import imconfig.PropertyDefinition;
import imconfig.types.internal.PropertyTypeFactory;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class PropertyDefinitionParser {
    private final Yaml yaml = new Yaml();
    private final PropertyTypeFactory typeFactory = new PropertyTypeFactory();

    Collection<PropertyDefinition> read(Reader reader) {
        Map map = (Map)this.yaml.loadAs(reader, HashMap.class);
        return map.entrySet().stream().map(this::parseDefinition).collect(Collectors.toList());
    }

    Collection<PropertyDefinition> read(InputStream inputStream) {
        Map map = (Map)this.yaml.loadAs(inputStream, HashMap.class);
        return map.entrySet().stream().map(this::parseDefinition).collect(Collectors.toList());
    }

    private PropertyDefinition parseDefinition(Map.Entry<String, Map<String, Object>> entry) {
        try {
            Map<String, Object> definition = entry.getValue();
            return PropertyDefinition.builder().property(entry.getKey()).description((String)definition.get("description")).required((Boolean)definition.get("required")).defaultValue(this.toString(definition.get("defaultValue"))).propertyType(this.typeFactory.create((String)definition.get("type"), (Map)definition.get("constraints"))).build();
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Bad configuration of property '" + entry.getKey() + "' : " + e.getMessage(), e);
        }
    }

    private String toString(Object object) {
        return object == null ? null : object.toString();
    }
}

