/*
 * Decompiled with CFR 0.152.
 */
package imconfig.types;

import imconfig.PropertyType;

public class DecimalPropertyType
implements PropertyType {
    private final Double min;
    private final Double max;

    public DecimalPropertyType(Number min, Number max) {
        this.min = min == null ? null : Double.valueOf(min.doubleValue());
        Double d = this.max = max == null ? null : Double.valueOf(max.doubleValue());
        if (this.min != null && this.max != null && this.min > this.max) {
            throw new IllegalArgumentException("Minimum value cannot be greater than maximum value");
        }
    }

    @Override
    public String name() {
        return "decimal";
    }

    @Override
    public String hint() {
        Object hint = this.min == null && this.max == null ? "Any decimal number" : (this.min == null ? "Decimal number less than " + this.max : (this.max == null ? "Decimal number greater than " + this.min : "Decimal number between " + this.min + " and " + this.max));
        return hint;
    }

    @Override
    public boolean accepts(String value) {
        boolean accepted = true;
        try {
            Double parsedValue = Double.valueOf(value);
            if (this.min != null && parsedValue.compareTo(this.min) < 0) {
                accepted = false;
            }
            if (this.max != null && parsedValue.compareTo(this.max) > 0) {
                accepted = false;
            }
            return accepted;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

