/*
 * Decompiled with CFR 0.152.
 */
package imconfig.types;

import imconfig.PropertyType;

public class IntegerPropertyType
implements PropertyType {
    private final Long min;
    private final Long max;

    public IntegerPropertyType(Number min, Number max) {
        this.min = min == null ? null : Long.valueOf(min.longValue());
        Long l = this.max = max == null ? null : Long.valueOf(max.longValue());
        if (this.min != null && this.max != null && this.min > this.max) {
            throw new IllegalArgumentException("Minimum value cannot be greater than maximum value");
        }
    }

    @Override
    public String name() {
        return "integer";
    }

    @Override
    public String hint() {
        Object hint = this.min == null && this.max == null ? "Any integer number" : (this.min == null ? "Integer number less than " + this.max : (this.max == null ? "Integer number greater than " + this.min : "Integer number between " + this.min + " and " + this.max));
        return hint;
    }

    @Override
    public boolean accepts(String value) {
        boolean accepted = true;
        try {
            Long parsedValue = Long.valueOf(value);
            if (this.min != null && parsedValue.compareTo(this.min) < 0) {
                accepted = false;
            }
            if (this.max != null && parsedValue.compareTo(this.max) > 0) {
                accepted = false;
            }
            return accepted;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

