/*
 * Decompiled with CFR 0.152.
 */
package imconfig.types;

import imconfig.PropertyType;
import java.util.regex.Pattern;

public class TextPropertyType
implements PropertyType {
    private final Pattern pattern;

    public TextPropertyType(String pattern) {
        this.pattern = pattern == null ? null : Pattern.compile(pattern);
    }

    @Override
    public String name() {
        return "text";
    }

    @Override
    public boolean accepts(String value) {
        return this.pattern == null || this.pattern.matcher(value).matches();
    }

    @Override
    public String hint() {
        return this.pattern == null ? "Any text" : "Text satisfying regex //" + this.pattern + "//";
    }

    public String pattern() {
        return this.pattern.pattern();
    }
}

