/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

public class FetchedArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Path path;
    private final List<FetchedArtifact> dependencies;

    public FetchedArtifact(String groupId, String artifactId, String version, Path path, List<FetchedArtifact> dependencies) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.path = path;
        this.dependencies = dependencies;
    }

    public String groupId() {
        return this.groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public String coordinates() {
        return this.groupId() + ":" + this.artifactId() + ":" + this.version();
    }

    public Stream<FetchedArtifact> dependencies() {
        return this.dependencies.stream();
    }

    public Stream<FetchedArtifact> allDepedencies() {
        return Stream.concat(this.dependencies(), this.dependencies().flatMap(FetchedArtifact::allDepedencies));
    }

    public Path path() {
        return this.path;
    }

    public String toString() {
        return this.toString(0, new StringBuilder()).toString();
    }

    private StringBuilder toString(int level, StringBuilder string) {
        for (int i = 0; i < level; ++i) {
            string.append("   ");
        }
        string.append("|- ").append(this.coordinates()).append("  [").append(this.path).append("]").append("\n");
        for (FetchedArtifact child : this.dependencies) {
            child.toString(level + 1, string);
        }
        return string;
    }
}

