/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import maven.fetcher.MavenFetchRequest;
import maven.fetcher.MavenFetchResult;
import maven.fetcher.internal.MavenFetchResultImpl;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;

public class MavenDependencyFetcher
implements DependencySelector {
    private final DefaultRepositorySystemSession session;
    private final Collection<String> scopes;
    private final boolean retrieveOptionals;
    private final List<Dependency> dependencies;
    private final List<Exclusion> exclusions;
    private final List<RemoteRepository> remoteRepositories;
    private final RepositorySystem system;
    private final Logger logger;
    private Set<String> retrievedArtifacts;

    public MavenDependencyFetcher(RepositorySystem system, List<RemoteRepository> remoteRepositories, DefaultRepositorySystemSession session, MavenFetchRequest fetchRequest, Logger logger) {
        this.system = system;
        this.remoteRepositories = remoteRepositories;
        this.session = session.setDependencySelector((DependencySelector)this);
        this.scopes = fetchRequest.scopes();
        this.retrieveOptionals = fetchRequest.isRetrievingOptionals();
        this.exclusions = fetchRequest.excludedArtifacts().stream().map(this::exclusionFromCoordinates).collect(Collectors.toList());
        this.dependencies = fetchRequest.artifacts().stream().map(this::artifactFromCoordinates).map(artifact -> new Dependency((Artifact)artifact, null, Boolean.valueOf(false), this.exclusions)).collect(Collectors.toList());
        this.logger = logger;
    }

    public MavenFetchResult fetch() throws DependencyCollectionException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using the following repositories:");
            for (RemoteRepository remoteRepository : this.remoteRepositories) {
                this.logger.info("- {repository} [{uri}]", (Object)remoteRepository.getId(), (Object)remoteRepository.getUrl());
            }
        }
        this.retrievedArtifacts = new HashSet<String>();
        CollectRequest request = new CollectRequest(this.dependencies, this.dependencies, this.remoteRepositories);
        CollectResult result = this.system.collectDependencies((RepositorySystemSession)this.session, request);
        this.retrieveDependency(result.getRoot());
        return new MavenFetchResultImpl(result, this.session);
    }

    private DefaultArtifact artifactFromCoordinates(String coordinates) {
        try {
            return new DefaultArtifact(coordinates);
        }
        catch (IllegalArgumentException e) {
            String[] parts = coordinates.split(":");
            if (parts.length == 2) {
                try {
                    String groupId = parts[0];
                    String artifactId = parts[1];
                    VersionRequest versionRequest = new VersionRequest().setArtifact((Artifact)new DefaultArtifact(groupId, artifactId, "jar", "LATEST")).setRepositories(this.remoteRepositories);
                    String version = this.system.resolveVersion((RepositorySystemSession)this.session, versionRequest).getVersion();
                    return new DefaultArtifact(groupId, artifactId, "jar", version);
                }
                catch (VersionResolutionException ex) {
                    throw new IllegalArgumentException("Cannot resolve artifact version: " + ex.getMessage(), ex);
                }
            }
            throw e;
        }
    }

    private Exclusion exclusionFromCoordinates(String coordinates) {
        String[] parts = coordinates.split(":");
        if (parts.length >= 2) {
            String groupId = parts[0];
            String artifactId = parts[1];
            return new Exclusion(groupId, artifactId, "jar", null);
        }
        throw new IllegalArgumentException("Invalid exclusion '" + coordinates + "'");
    }

    private void retrieveDependency(DependencyNode node) {
        block5: {
            if (node.getArtifact() != null) {
                if (this.isExcluded(node.getArtifact())) {
                    return;
                }
                try {
                    ArtifactRequest request = new ArtifactRequest(node.getArtifact(), this.remoteRepositories, null);
                    this.system.resolveArtifact((RepositorySystemSession)this.session, request);
                }
                catch (ArtifactResolutionException e) {
                    if (e.getCause() instanceof ArtifactNotFoundException) break block5;
                    this.logger.debug("<caused by>", (Throwable)e);
                }
            }
        }
        for (DependencyNode child : node.getChildren()) {
            this.retrieveDependency(child);
        }
    }

    private boolean isExcluded(Artifact artifact) {
        for (Exclusion exclusion : this.exclusions) {
            if (!exclusion.getGroupId().equals(artifact.getGroupId()) || !exclusion.getArtifactId().equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public boolean selectDependency(Dependency dependency) {
        String artifactKey = MavenDependencyFetcher.key(dependency.getArtifact());
        if (this.retrievedArtifacts.contains(artifactKey) || dependency.isOptional() && !this.retrieveOptionals || !dependency.getScope().isEmpty() && !this.scopes.contains(dependency.getScope())) {
            return false;
        }
        this.retrievedArtifacts.add(artifactKey);
        return true;
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        return this;
    }

    private static String key(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }
}

