/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import maven.fetcher.FetchedArtifact;
import maven.fetcher.MavenFetchResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.LocalRepositoryManager;

public class MavenFetchResultImpl
implements MavenFetchResult {
    private final CollectResult result;
    private final List<FetchedArtifact> rootArtifacts;

    MavenFetchResultImpl(CollectResult result, DefaultRepositorySystemSession session) {
        this.result = result;
        LocalRepositoryManager localRepositoryManager = session.getLocalRepositoryManager();
        Path repositoryPath = localRepositoryManager.getRepository().getBasedir().toPath();
        this.rootArtifacts = result.getRoot().getChildren().stream().map(node -> this.collectArtifact((DependencyNode)node, localRepositoryManager, repositoryPath)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<FetchedArtifact> collectArtifact(DependencyNode node, LocalRepositoryManager localRepositoryManager, Path repositoryPath) {
        Artifact artifact = node.getArtifact();
        Path localPath = repositoryPath.resolve(localRepositoryManager.getPathForLocalArtifact(artifact));
        if (!Files.exists(localPath, new LinkOption[0])) {
            return Optional.empty();
        }
        List<FetchedArtifact> dependencies = node.getChildren().stream().map(child -> this.collectArtifact((DependencyNode)child, localRepositoryManager, repositoryPath)).flatMap(Optional::stream).collect(Collectors.toList());
        return Optional.of(new FetchedArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), localPath, dependencies));
    }

    @Override
    public Stream<FetchedArtifact> artifacts() {
        return this.rootArtifacts.stream();
    }

    @Override
    public Stream<FetchedArtifact> allArtifacts() {
        return Stream.concat(this.artifacts(), this.artifacts().flatMap(FetchedArtifact::allDepedencies));
    }

    @Override
    public boolean hasErrors() {
        return this.result.getExceptions().isEmpty();
    }

    public String toString() {
        return this.artifacts().map(FetchedArtifact::toString).collect(Collectors.joining("\n"));
    }
}

