/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher.internal;

import java.util.Objects;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;

public class MavenTransferLogger
implements TransferListener {
    private final Logger logger;

    public MavenTransferLogger(Logger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        if (event.getResource().getResourceName().endsWith(".jar") && this.logger.isInfoEnabled()) {
            this.logger.debug("Transfering {artifact} [{}] from {uri}  ...", new Object[]{this.resourceName(event), this.resourceSize(event), this.repository(event)});
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        if (event.getResource().getResourceName().endsWith(".jar") && this.logger.isErrorEnabled()) {
            this.logger.error("Checksum validation failed for [{artifact}]", (Object)this.resourceName(event));
        }
    }

    public void transferSucceeded(TransferEvent event) {
        if (event.getResource().getResourceName().endsWith(".jar") && this.logger.isInfoEnabled()) {
            this.logger.info("{artifact} [{}] downloaded from {uri} ", new Object[]{this.resourceName(event), this.resourceSize(event), this.repository(event)});
        }
    }

    public void transferFailed(TransferEvent event) {
        if (event.getResource().getResourceName().endsWith(".jar") && this.logger.isErrorEnabled()) {
            this.logger.warn("Cannot download {artifact} from {uri}", (Object)this.resourceName(event), (Object)event.getResource().getRepositoryUrl());
        }
    }

    private String resourceName(TransferEvent event) {
        int index = event.getResource().getResourceName().lastIndexOf(47);
        return String.format("%-40s", event.getResource().getResourceName().substring(index < 0 ? 0 : index + 1));
    }

    private String resourceSize(TransferEvent event) {
        long size = event.getResource().getContentLength();
        return String.format("%7s", size > 1000L ? size / 1000L + " Kb" : size + " bytes");
    }

    private String repository(TransferEvent event) {
        return event.getResource().getRepositoryUrl();
    }
}

