/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MavenFetchRequest {
    private final Collection<String> artifacts;
    private Collection<String> scopes = Arrays.asList("compile", "provided");
    private boolean retrievingOptionals = false;
    private List<String> excludedArtifacts = List.of();

    public MavenFetchRequest(Collection<String> artifacts) {
        this.artifacts = List.copyOf(artifacts);
    }

    public MavenFetchRequest(String ... artifacts) {
        this.artifacts = List.copyOf(Arrays.asList(artifacts));
    }

    public MavenFetchRequest scopes(String ... scopes) {
        this.scopes = List.copyOf(Arrays.asList(scopes));
        return this;
    }

    public MavenFetchRequest excludingArtifacts(String ... artifacts) {
        this.excludedArtifacts = List.copyOf(Arrays.asList(artifacts));
        return this;
    }

    public MavenFetchRequest retrievingOptionals() {
        this.retrievingOptionals = true;
        return this;
    }

    public Collection<String> artifacts() {
        return this.artifacts;
    }

    public Collection<String> scopes() {
        return this.scopes;
    }

    public boolean isRetrievingOptionals() {
        return this.retrievingOptionals;
    }

    public Collection<String> excludedArtifacts() {
        return this.excludedArtifacts;
    }
}

