/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import maven.fetcher.MavenFetchException;
import maven.fetcher.MavenFetchRequest;
import maven.fetcher.MavenFetchResult;
import maven.fetcher.Repository;
import maven.fetcher.internal.MavenDependencyFetcher;
import maven.fetcher.internal.MavenTransferListener;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slf4jansi.AnsiLogger;

public class MavenFetcher {
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>(List.of(MavenFetcher.createRemoteRepository("maven-central", "https://repo.maven.apache.org/maven2")));
    private RepositorySystem system;
    private LocalRepository localRepository;
    private String proxyURL;
    private String proxyUsername;
    private String proxyPassword;
    private List<String> proxyExceptions;
    private Logger logger = AnsiLogger.of((Logger)LoggerFactory.getLogger(MavenFetcher.class));

    public MavenFetcher logger(Logger logger) {
        this.logger = AnsiLogger.of((Logger)logger);
        return this;
    }

    public MavenFetcher proxyURL(String url) throws MalformedURLException {
        MavenFetcher.checkURL(url);
        MavenFetcher.checkNonNull(url);
        this.proxyURL = url;
        return this;
    }

    public MavenFetcher proxyCredentials(String username, String password) {
        MavenFetcher.checkNonNull(username, password);
        this.proxyUsername = username;
        this.proxyPassword = password;
        return this;
    }

    public MavenFetcher proxyExceptions(Collection<String> exceptions) {
        MavenFetcher.checkNonNull(exceptions);
        this.proxyExceptions = new ArrayList<String>(exceptions);
        return this;
    }

    public MavenFetcher localRepositoryPath(String localRepositoryPath) {
        this.localRepository = new LocalRepository(localRepositoryPath);
        return this;
    }

    public MavenFetcher localRepositoryPath(Path localRepositoryPath) {
        if (localRepositoryPath == null) {
            throw new IllegalArgumentException("Local repository path cannot be null");
        }
        return this.localRepositoryPath(localRepositoryPath.toString());
    }

    public MavenFetcher clearRemoteRepositories() {
        this.remoteRepositories.clear();
        return this;
    }

    public MavenFetcher addRemoteRepository(Repository repository) {
        if (repository.priority() > -1) {
            this.remoteRepositories.add(repository.priority(), MavenFetcher.parseRemoteRepository(repository.toString()));
        } else {
            this.remoteRepositories.add(MavenFetcher.parseRemoteRepository(repository.toString()));
        }
        return this;
    }

    public MavenFetcher addRemoteRepository(String id, String url) {
        return this.addRemoteRepository(new Repository(id, url));
    }

    public List<String> remoteRepositories() {
        return this.remoteRepositories.stream().map(RemoteRepository::toString).collect(Collectors.toList());
    }

    public MavenFetcher config(Properties properties) {
        if ("false".equalsIgnoreCase(properties.getProperty("useDefaultRemoteRepository", "true"))) {
            this.clearRemoteRepositories();
        }
        for (Object property : properties.keySet()) {
            try {
                String value = properties.getProperty(property.toString());
                switch (property.toString()) {
                    case "remoteRepositories": {
                        this.addRemoteRepositories(Arrays.asList(value.split(";")));
                        break;
                    }
                    case "localRepository": {
                        this.localRepositoryPath(value);
                        break;
                    }
                    case "proxy.username": {
                        this.proxyUsername = value;
                        break;
                    }
                    case "proxy.password": {
                        this.proxyPassword = value;
                        break;
                    }
                    case "proxy.exceptions": {
                        this.proxyExceptions = Arrays.asList(value.split(";"));
                        break;
                    }
                    case "proxy.url": {
                        MavenFetcher.checkURL(value);
                        this.proxyURL = value;
                        break;
                    }
                    default: {
                        this.logger.warn("Property {} is not recognized and would be ignored", property);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new MavenFetchException("Invalid value for property '" + property + "' : " + e.getMessage(), e);
            }
        }
        return this;
    }

    private void addRemoteRepositories(List<String> repositories) {
        for (String repository : repositories) {
            this.remoteRepositories.add(MavenFetcher.parseRemoteRepository(repository));
        }
    }

    public MavenFetchResult fetchArtifacts(MavenFetchRequest request) {
        try {
            if (this.remoteRepositories.isEmpty()) {
                throw new IllegalArgumentException("Remote repositories not specified");
            }
            MavenTransferListener listener = new MavenTransferListener(this.logger);
            MavenFetchResult result = new MavenDependencyFetcher(this.system(), this.remoteRepositories, this.newSession(listener), request, listener, this.logger).fetch();
            if (result.hasErrors()) {
                this.logger.warn("Some dependencies were not fetched!");
            }
            this.logger.info("{} artifacts resolved.", (Object)result.allArtifacts().count());
            return result;
        }
        catch (DependencyCollectionException e) {
            throw new MavenFetchException(e);
        }
    }

    private RepositorySystem system() {
        if (this.system == null) {
            this.system = this.newRepositorySystem(MavenRepositorySystemUtils.newServiceLocator());
            if (this.system == null) {
                throw new NullPointerException("Cannot instantiate system");
            }
        }
        return this.system;
    }

    private DefaultRepositorySystemSession newSession(MavenTransferListener listener) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(this.system().newLocalRepositoryManager((RepositorySystemSession)session, this.localRepository));
        session.setTransferListener((TransferListener)listener);
        this.proxy().ifPresent(arg_0 -> ((DefaultRepositorySystemSession)session).setProxySelector(arg_0));
        return session;
    }

    private Optional<ProxySelector> proxy() {
        URL url;
        if (this.proxyURL == null) {
            return Optional.empty();
        }
        try {
            url = new URL(this.proxyURL);
        }
        catch (MalformedURLException e) {
            throw new MavenFetchException(e);
        }
        int port = url.getPort() < 0 ? 8080 : url.getPort();
        Authentication authentication = null;
        if (this.proxyUsername != null) {
            authentication = new AuthenticationBuilder().addUsername(this.proxyUsername).addPassword(this.proxyPassword).build();
        }
        Proxy proxy = new Proxy(url.getProtocol(), url.getHost(), port, authentication);
        return Optional.of(new DefaultProxySelector().add(proxy, this.proxyExceptions == null ? "" : String.join((CharSequence)"|", this.proxyExceptions)));
    }

    private RepositorySystem newRepositorySystem(DefaultServiceLocator locator) {
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                MavenFetcher.this.logger.error("Cannot create instance of {} for service {}", new Object[]{impl, type, exception});
            }
        });
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static RemoteRepository createRemoteRepository(String id, String url) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(url);
        return new RemoteRepository.Builder(id, "default", url).build();
    }

    private static RemoteRepository createRemoteRepository(String id, String url, String user, String password) {
        return new RemoteRepository.Builder(id, "default", url).setAuthentication(new AuthenticationBuilder().addUsername(user).addPassword(password).build()).build();
    }

    private static RemoteRepository parseRemoteRepository(String value) {
        String expression = value.strip().replaceAll("\\s+", " ");
        String[] parts = expression.split("=", 2);
        if (parts.length != 2) {
            MavenFetcher.throwInvalidRepositoryValue(value);
        }
        String id = parts[0];
        expression = parts[1];
        parts = expression.split(" ", 2);
        String url = parts[0];
        if (parts.length == 1) {
            return MavenFetcher.createRemoteRepository(id, url);
        }
        int start = parts[1].indexOf("[");
        int end = parts[1].lastIndexOf("]");
        if (start == -1 || end == -1) {
            MavenFetcher.throwInvalidRepositoryValue(value);
        }
        if ((parts = (expression = parts[1].substring(start + 1, end)).split(":", 2)).length != 2) {
            MavenFetcher.throwInvalidRepositoryValue(value);
        }
        return MavenFetcher.createRemoteRepository(id, url, parts[0], parts[1]);
    }

    private static void throwInvalidRepositoryValue(String value) {
        throw new IllegalArgumentException("Invalid repository value '" + value + "' .\nExpected formats are 'id=url' and 'id=url [user:pwd]'");
    }

    private static void checkNonNull(Object ... objects) {
        for (Object object : objects) {
            Objects.requireNonNull(object);
        }
    }

    private static void checkNonNull(Collection<?> collection) {
        Objects.requireNonNull(collection);
        for (Object object : collection) {
            Objects.requireNonNull(object);
        }
    }

    private static void checkURL(String url) throws MalformedURLException {
        new URL(url);
    }

    static {
        AnsiLogger.addStyle((String)"repository", (String)"yellow,bold");
        AnsiLogger.addStyle((String)"artifact", (String)"green,bold");
    }
}

