/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import maven.fetcher.MavenFetcher;
import maven.fetcher.Repository;

public class MavenFetcherConfig {
    public static final String REMOTE_REPOSITORIES = "remoteRepositories";
    public static final String LOCAL_REPOSITORY = "localRepository";
    public static final String PROXY_URL = "proxy.url";
    public static final String PROXY_USERNAME = "proxy.username";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_EXCEPTIONS = "proxy.exceptions";
    private final Properties properties;

    public MavenFetcherConfig(String configFile) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
            this.properties = new Properties();
            this.properties.load(reader);
        }
    }

    public MavenFetcherConfig(Properties properties) {
        this.properties = properties;
    }

    public void config(MavenFetcher fetcher) throws MalformedURLException {
        String proxyUrl;
        String localRepository;
        String remoteRepositories = this.properties.getProperty(REMOTE_REPOSITORIES);
        if (remoteRepositories != null) {
            for (String remoteRepository : remoteRepositories.split(";")) {
                fetcher.addRemoteRepository(new Repository(remoteRepository, remoteRepository));
            }
        }
        if ((localRepository = this.properties.getProperty(LOCAL_REPOSITORY)) != null) {
            fetcher.localRepositoryPath(localRepository);
        }
        if ((proxyUrl = this.properties.getProperty(PROXY_URL)) != null) {
            String proxyExceptions;
            fetcher.proxyURL(proxyUrl);
            String proxyUsername = this.properties.getProperty(PROXY_USERNAME);
            String proxyPassword = this.properties.getProperty(PROXY_PASSWORD);
            if (proxyUsername != null && proxyPassword != null) {
                fetcher.proxyCredentials(proxyUsername, proxyPassword);
            }
            if ((proxyExceptions = this.properties.getProperty(PROXY_EXCEPTIONS)) != null) {
                fetcher.proxyExceptions(Arrays.asList(proxyExceptions.split(";")));
            }
        }
    }
}

