/*
 * Decompiled with CFR 0.152.
 */
package maven.fetcher.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;

public class MavenTransferListener
implements TransferListener {
    private final Logger logger;
    private final List<String> succededTransfers = new ArrayList<String>();
    private final List<String> failedTransfers = new ArrayList<String>();

    public MavenTransferListener(Logger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    public List<String> succededTransfers() {
        return List.copyOf(this.succededTransfers);
    }

    public List<String> failedTransfers() {
        return List.copyOf(this.failedTransfers);
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        if (event.getResource().getResourceName().endsWith(".jar") && this.logger.isInfoEnabled()) {
            this.logger.debug("Transferring {artifact} [{}] from {uri}  ...", new Object[]{this.resourceName(event), this.resourceSize(event), this.repository(event)});
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        if (event.getResource().getResourceName().endsWith(".jar") && this.logger.isErrorEnabled()) {
            this.logger.error("Checksum validation failed for [{artifact}]", (Object)this.resourceName(event));
        }
    }

    public void transferSucceeded(TransferEvent event) {
        if (event.getResource().getResourceName().endsWith(".jar")) {
            this.succededTransfers.add(this.resourceNameTrimmed(event));
            this.failedTransfers.remove(this.resourceNameTrimmed(event));
            if (this.logger.isInfoEnabled() && event.getResource().getContentLength() > 0L) {
                this.logger.info("{artifact} [{}] downloaded from {uri} ", new Object[]{this.resourceName(event), this.resourceSize(event), this.repository(event)});
            }
        }
    }

    public void transferFailed(TransferEvent event) {
        if (event.getResource().getResourceName().endsWith(".jar")) {
            this.failedTransfers.add(this.resourceNameTrimmed(event));
            if (this.logger.isErrorEnabled()) {
                this.logger.warn("Cannot download {artifact} from {uri}", (Object)this.resourceName(event), (Object)event.getResource().getRepositoryUrl());
            }
        }
    }

    private String resourceName(TransferEvent event) {
        return String.format("%-40s", this.resourceNameTrimmed(event));
    }

    private String resourceNameTrimmed(TransferEvent event) {
        int index = event.getResource().getResourceName().lastIndexOf(47);
        return event.getResource().getResourceName().substring(index < 0 ? 0 : index + 1);
    }

    private String resourceSize(TransferEvent event) {
        long size = event.getResource().getContentLength();
        return String.format("%7s", size > 1000L ? size / 1000L + " Kb" : size + " bytes");
    }

    private String repository(TransferEvent event) {
        return event.getResource().getRepositoryUrl();
    }
}

