/*
 * Decompiled with CFR 0.152.
 */
package slf4jansi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;
import slf4jansi.impl.DefaultStyles;
import slf4jansi.impl.LocationAwareAnsiLogger;
import slf4jansi.impl.SimpleAnsiLogger;

public class AnsiLogger {
    private static Properties styles = DefaultStyles.asProperties();
    private static List<Runnable> configurationChangeObservers = new ArrayList<Runnable>();

    public static Logger of(Logger logger) {
        if (logger instanceof LocationAwareLogger) {
            return new LocationAwareAnsiLogger((LocationAwareLogger)logger);
        }
        return new SimpleAnsiLogger(logger);
    }

    public static void setAnsiEnabled(boolean enabled) {
        Ansi.setEnabled((boolean)enabled);
    }

    public static boolean isAnsiEnabled() {
        return Ansi.isEnabled();
    }

    public static void setStyles(Properties styles) {
        Properties properties = DefaultStyles.asProperties();
        for (Object key : styles.keySet()) {
            properties.put(key, styles.getProperty(key.toString()));
        }
        AnsiLogger.styles = properties;
        configurationChangeObservers.forEach(Runnable::run);
    }

    public static void addStyle(String key, String value) {
        styles.put(key, value);
        configurationChangeObservers.forEach(Runnable::run);
    }

    public static Properties styles() {
        return styles;
    }

    public static void addConfigurationChangeObserver(Runnable observerMethod) {
        configurationChangeObservers.add(observerMethod);
    }
}

