/*
 * Decompiled with CFR 0.152.
 */
package slf4jansi.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.Ansi;
import slf4jansi.AnsiLogger;

final class JAnsiSupport {
    public static final JAnsiSupport instance = new JAnsiSupport();
    private static final Pattern globalStylePattern = Pattern.compile("^\\{!([^}]*)\\}.*");
    private static final Pattern stylePattern = Pattern.compile("\\{([^}]*)\\}");
    private Map<String, String> styles;

    private JAnsiSupport() {
        AnsiLogger.addConfigurationChangeObserver(this::invalidateStyles);
    }

    private String replaceStyles(String globalStyle, String message) {
        Matcher globalStyleMatcher;
        if (this.styles == null) {
            this.styles = new HashMap<String, String>();
            AnsiLogger.styles().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.styles.put("{" + key + "}", "@|" + value + " {}|@")));
        }
        if ((globalStyleMatcher = globalStylePattern.matcher((CharSequence)message)).matches()) {
            globalStyle = globalStyleMatcher.group(1);
            message = ((String)message).substring(((String)message).indexOf(125) + 1).trim();
        }
        Matcher styleMatcher = stylePattern.matcher((CharSequence)message);
        while (styleMatcher.find()) {
            String foundStyle = "{" + styleMatcher.group(1) + "}";
            String style = this.styles.getOrDefault(foundStyle, "{}");
            message = ((String)message).replace(foundStyle, style);
        }
        if (globalStyle != null) {
            globalStyle = AnsiLogger.styles().getProperty(globalStyle);
        }
        if (globalStyle != null) {
            message = "$|" + ((String)message).replace("|@", "|@$|").replace("@|", "|$@|") + "|$";
            message = ((String)message).replace("$|", "@|" + globalStyle + " ").replace("|$", "|@");
        }
        return message;
    }

    private void invalidateStyles() {
        this.styles = null;
    }

    String ansi(String level, String message) {
        return message == null ? null : Ansi.ansi().render(this.replaceStyles(level, message)).toString();
    }
}

