/*
 * Decompiled with CFR 0.152.
 */
package slf4jansi.impl;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;
import slf4jansi.impl.JAnsiSupport;

public class LocationAwareAnsiLogger
implements Logger {
    private static final String[] stringLevel = new String[]{"trace", "debug", "info", "warn", "error"};
    private final LocationAwareLogger delegate;
    private final JAnsiSupport jAnsi = JAnsiSupport.instance;

    public LocationAwareAnsiLogger(LocationAwareLogger delegate) {
        this.delegate = delegate;
    }

    private String fqnc() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.delegate.getName();
    }

    private void log(boolean enabled, int level, Marker marker, String message, Object ... args) {
        if (enabled) {
            Throwable throwable = null;
            if (args != null && args.length > 0 && args[args.length - 1] instanceof Throwable) {
                throwable = (Throwable)args[args.length - 1];
                args = Arrays.copyOf(args, args.length - 1);
            }
            this.delegate.log(marker, this.fqnc(), level, this.jAnsi.ansi(stringLevel[level / 10], message), args, throwable);
        }
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(String message) {
        this.log(this.delegate.isTraceEnabled(), 0, null, message, new Object[0]);
    }

    public void trace(String message, Object arg) {
        this.log(this.delegate.isTraceEnabled(), 0, null, message, arg);
    }

    public void trace(String message, Object arg1, Object arg2) {
        this.log(this.delegate.isTraceEnabled(), 0, null, message, arg1, arg2);
    }

    public void trace(String message, Object ... arguments) {
        this.log(this.delegate.isTraceEnabled(), 0, null, message, arguments);
    }

    public void trace(String message, Throwable throwable) {
        this.log(this.delegate.isTraceEnabled(), 0, null, message, throwable);
    }

    public void trace(Marker marker, String message) {
        this.log(this.delegate.isTraceEnabled(marker), 0, marker, message, new Object[0]);
    }

    public void trace(Marker marker, String message, Object arg) {
        this.log(this.delegate.isTraceEnabled(marker), 0, marker, message, arg);
    }

    public void trace(Marker marker, String message, Object arg1, Object arg2) {
        this.log(this.delegate.isTraceEnabled(marker), 0, marker, message, arg1, arg2);
    }

    public void trace(Marker marker, String message, Object ... arguments) {
        this.log(this.delegate.isTraceEnabled(marker), 0, marker, message, arguments);
    }

    public void trace(Marker marker, String message, Throwable throwable) {
        this.log(this.delegate.isTraceEnabled(marker), 0, marker, message, throwable);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(String message) {
        this.log(this.delegate.isDebugEnabled(), 10, null, message, new Object[0]);
    }

    public void debug(String message, Object arg) {
        this.log(this.delegate.isDebugEnabled(), 10, null, message, arg);
    }

    public void debug(String message, Object arg1, Object arg2) {
        this.log(this.delegate.isDebugEnabled(), 10, null, message, arg1, arg2);
    }

    public void debug(String message, Object ... arguments) {
        this.log(this.delegate.isDebugEnabled(), 10, null, message, arguments);
    }

    public void debug(String message, Throwable throwable) {
        this.log(this.delegate.isDebugEnabled(), 10, null, message, throwable);
    }

    public void debug(Marker marker, String message) {
        this.log(this.delegate.isDebugEnabled(marker), 10, marker, message, new Object[0]);
    }

    public void debug(Marker marker, String message, Object arg) {
        this.log(this.delegate.isDebugEnabled(marker), 10, marker, message, arg);
    }

    public void debug(Marker marker, String message, Object arg1, Object arg2) {
        this.log(this.delegate.isDebugEnabled(marker), 10, marker, message, arg1, arg2);
    }

    public void debug(Marker marker, String message, Object ... arguments) {
        this.log(this.delegate.isDebugEnabled(marker), 10, marker, message, arguments);
    }

    public void debug(Marker marker, String message, Throwable throwable) {
        this.log(this.delegate.isDebugEnabled(marker), 10, marker, message, throwable);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(String message) {
        this.log(this.delegate.isInfoEnabled(), 20, null, message, new Object[0]);
    }

    public void info(String message, Object arg) {
        this.log(this.delegate.isInfoEnabled(), 20, null, message, arg);
    }

    public void info(String message, Object arg1, Object arg2) {
        this.log(this.delegate.isInfoEnabled(), 20, null, message, arg1, arg2);
    }

    public void info(String message, Object ... arguments) {
        this.log(this.delegate.isInfoEnabled(), 20, null, message, arguments);
    }

    public void info(String message, Throwable throwable) {
        this.log(this.delegate.isInfoEnabled(), 20, null, message, throwable);
    }

    public void info(Marker marker, String message) {
        this.log(this.delegate.isInfoEnabled(marker), 20, marker, message, new Object[0]);
    }

    public void info(Marker marker, String message, Object arg) {
        this.log(this.delegate.isInfoEnabled(marker), 20, marker, message, arg);
    }

    public void info(Marker marker, String message, Object arg1, Object arg2) {
        this.log(this.delegate.isInfoEnabled(marker), 20, marker, message, arg1, arg2);
    }

    public void info(Marker marker, String message, Object ... arguments) {
        this.log(this.delegate.isInfoEnabled(marker), 20, marker, message, arguments);
    }

    public void info(Marker marker, String message, Throwable throwable) {
        this.log(this.delegate.isInfoEnabled(marker), 20, marker, message, throwable);
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(String message) {
        this.log(this.delegate.isWarnEnabled(), 30, null, message, new Object[0]);
    }

    public void warn(String message, Object arg) {
        this.log(this.delegate.isWarnEnabled(), 30, null, message, arg);
    }

    public void warn(String message, Object arg1, Object arg2) {
        this.log(this.delegate.isWarnEnabled(), 30, null, message, arg1, arg2);
    }

    public void warn(String message, Object ... arguments) {
        this.log(this.delegate.isWarnEnabled(), 30, null, message, arguments);
    }

    public void warn(String message, Throwable throwable) {
        this.log(this.delegate.isWarnEnabled(), 30, null, message, throwable);
    }

    public void warn(Marker marker, String message) {
        this.log(this.delegate.isWarnEnabled(marker), 30, marker, message, new Object[0]);
    }

    public void warn(Marker marker, String message, Object arg) {
        this.log(this.delegate.isWarnEnabled(marker), 30, marker, message, arg);
    }

    public void warn(Marker marker, String message, Object arg1, Object arg2) {
        this.log(this.delegate.isWarnEnabled(marker), 30, marker, message, arg1, arg2);
    }

    public void warn(Marker marker, String message, Object ... arguments) {
        this.log(this.delegate.isWarnEnabled(marker), 30, marker, message, arguments);
    }

    public void warn(Marker marker, String message, Throwable throwable) {
        this.log(this.delegate.isWarnEnabled(marker), 30, marker, message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void error(String message) {
        this.log(this.delegate.isErrorEnabled(), 40, null, message, new Object[0]);
    }

    public void error(String message, Object arg) {
        this.log(this.delegate.isErrorEnabled(), 40, null, message, arg);
    }

    public void error(String message, Object arg1, Object arg2) {
        this.log(this.delegate.isErrorEnabled(), 40, null, message, arg1, arg2);
    }

    public void error(String message, Object ... arguments) {
        this.log(this.delegate.isErrorEnabled(), 40, null, message, arguments);
    }

    public void error(String message, Throwable throwable) {
        this.log(this.delegate.isErrorEnabled(), 40, null, message, throwable);
    }

    public void error(Marker marker, String message) {
        this.log(this.delegate.isErrorEnabled(marker), 40, marker, message, new Object[0]);
    }

    public void error(Marker marker, String message, Object arg) {
        this.log(this.delegate.isErrorEnabled(marker), 40, marker, message, arg);
    }

    public void error(Marker marker, String message, Object arg1, Object arg2) {
        this.log(this.delegate.isErrorEnabled(marker), 40, marker, message, arg1, arg2);
    }

    public void error(Marker marker, String message, Object ... arguments) {
        this.log(this.delegate.isErrorEnabled(marker), 40, marker, message, arguments);
    }

    public void error(Marker marker, String message, Throwable throwable) {
        this.log(this.delegate.isErrorEnabled(marker), 40, marker, message, throwable);
    }
}

