/*
 * Decompiled with CFR 0.152.
 */
package slf4jansi.impl;

import org.slf4j.Logger;
import org.slf4j.Marker;
import slf4jansi.impl.JAnsiSupport;

public class SimpleAnsiLogger
implements Logger {
    private static final String ERROR = "error";
    private static final String WARN = "warn";
    private static final String INFO = "info";
    private static final String DEBUG = "debug";
    private static final String TRACE = "trace";
    private static final JAnsiSupport jAnsi = JAnsiSupport.instance;
    private final Logger delegate;

    public SimpleAnsiLogger(Logger delegate) {
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(jAnsi.ansi(TRACE, msg));
        }
    }

    public void trace(String format, Object arg) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(jAnsi.ansi(TRACE, format), arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(jAnsi.ansi(TRACE, format), arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(jAnsi.ansi(TRACE, format), arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(jAnsi.ansi(TRACE, msg), t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.delegate.isTraceEnabled(marker)) {
            this.delegate.trace(marker, jAnsi.ansi(TRACE, msg));
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.delegate.isTraceEnabled(marker)) {
            this.delegate.trace(marker, jAnsi.ansi(TRACE, format), arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.delegate.isTraceEnabled(marker)) {
            this.delegate.trace(marker, jAnsi.ansi(TRACE, format), arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.delegate.isTraceEnabled(marker)) {
            this.delegate.trace(marker, jAnsi.ansi(TRACE, format), argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.delegate.isTraceEnabled(marker)) {
            this.delegate.trace(marker, jAnsi.ansi(TRACE, msg), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(jAnsi.ansi(DEBUG, msg));
        }
    }

    public void debug(String format, Object arg) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(jAnsi.ansi(DEBUG, format), arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(jAnsi.ansi(DEBUG, format), arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(jAnsi.ansi(DEBUG, format), arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(jAnsi.ansi(DEBUG, msg), t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.delegate.isDebugEnabled(marker)) {
            this.delegate.debug(marker, jAnsi.ansi(DEBUG, msg));
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.delegate.isDebugEnabled(marker)) {
            this.delegate.debug(marker, jAnsi.ansi(DEBUG, format), arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.delegate.isDebugEnabled(marker)) {
            this.delegate.debug(marker, jAnsi.ansi(DEBUG, format), arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... argArray) {
        if (this.delegate.isDebugEnabled(marker)) {
            this.delegate.debug(marker, jAnsi.ansi(DEBUG, format), argArray);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.delegate.isDebugEnabled(marker)) {
            this.delegate.debug(marker, jAnsi.ansi(DEBUG, msg), t);
        }
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(jAnsi.ansi(INFO, msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(jAnsi.ansi(INFO, format), arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(jAnsi.ansi(INFO, format), arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(jAnsi.ansi(INFO, format), arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(jAnsi.ansi(INFO, msg), t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.delegate.isInfoEnabled(marker)) {
            this.delegate.info(marker, jAnsi.ansi(INFO, msg));
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.delegate.isInfoEnabled(marker)) {
            this.delegate.info(marker, jAnsi.ansi(INFO, format), arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.delegate.isInfoEnabled(marker)) {
            this.delegate.info(marker, jAnsi.ansi(INFO, format), arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... argArray) {
        if (this.delegate.isInfoEnabled(marker)) {
            this.delegate.info(marker, jAnsi.ansi(INFO, format), argArray);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.delegate.isInfoEnabled(marker)) {
            this.delegate.info(marker, jAnsi.ansi(INFO, msg), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(jAnsi.ansi(WARN, msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(jAnsi.ansi(WARN, format), arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(jAnsi.ansi(WARN, format), arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(jAnsi.ansi(WARN, format), arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(jAnsi.ansi(WARN, msg), t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.delegate.isWarnEnabled(marker)) {
            this.delegate.warn(marker, jAnsi.ansi(WARN, msg));
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.delegate.isWarnEnabled(marker)) {
            this.delegate.warn(marker, jAnsi.ansi(WARN, format), arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.delegate.isWarnEnabled(marker)) {
            this.delegate.warn(marker, jAnsi.ansi(WARN, format), arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... argArray) {
        if (this.delegate.isWarnEnabled(marker)) {
            this.delegate.warn(marker, jAnsi.ansi(WARN, format), argArray);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.delegate.isWarnEnabled(marker)) {
            this.delegate.warn(marker, jAnsi.ansi(WARN, msg), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(jAnsi.ansi(ERROR, msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(jAnsi.ansi(ERROR, format), arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(jAnsi.ansi(ERROR, format), arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(jAnsi.ansi(ERROR, format), arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(jAnsi.ansi(ERROR, msg), t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.delegate.isErrorEnabled(marker)) {
            this.delegate.error(marker, jAnsi.ansi(ERROR, msg));
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.delegate.isErrorEnabled(marker)) {
            this.delegate.error(marker, jAnsi.ansi(ERROR, format), arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.delegate.isErrorEnabled(marker)) {
            this.delegate.error(marker, jAnsi.ansi(ERROR, format), arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... argArray) {
        if (this.delegate.isErrorEnabled(marker)) {
            this.delegate.error(marker, jAnsi.ansi(ERROR, format), argArray);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.delegate.isErrorEnabled(marker)) {
            this.delegate.error(marker, jAnsi.ansi(ERROR, msg), t);
        }
    }
}

