/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.InterfaceNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClassGraphBuilder {
    private final HashMap<String, ClassNode> classNameToClassNode = new HashMap();
    private final HashMap<String, InterfaceNode> interfaceNameToInterfaceNode = new HashMap();
    private final HashMap<String, ArrayList<String>> annotationNameToClassName = new HashMap();
    private final HashMap<String, ArrayList<String>> interfaceNameToClassNames = new HashMap();

    public ArrayList<String> getClassesWithAnnotation(String annotationName) {
        return this.annotationNameToClassName.get(annotationName);
    }

    public ArrayList<String> getClassesImplementing(String interfaceName) {
        return this.interfaceNameToClassNames.get(interfaceName);
    }

    public ArrayList<String> getSubclassesOf(String className) {
        ArrayList<String> subclasses = new ArrayList<String>();
        ClassNode classNode = this.classNameToClassNode.get(className);
        if (classNode != null) {
            for (DAGNode subNode : classNode.allSubNodes) {
                subclasses.add(subNode.name);
            }
        }
        return subclasses;
    }

    public ArrayList<String> getSuperclassesOf(String className) {
        ArrayList<String> superclasses = new ArrayList<String>();
        ClassNode classNode = this.classNameToClassNode.get(className);
        if (classNode != null) {
            for (DAGNode subNode : classNode.allSuperNodes) {
                superclasses.add(subNode.name);
            }
        }
        return superclasses;
    }

    public ArrayList<String> getSubinterfacesOf(String interfaceName) {
        ArrayList<String> subinterfaces = new ArrayList<String>();
        InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.get(interfaceName);
        if (interfaceNode != null) {
            for (DAGNode subNode : interfaceNode.allSubNodes) {
                subinterfaces.add(subNode.name);
            }
        }
        return subinterfaces;
    }

    public ArrayList<String> getSuperinterfacesOf(String interfaceName) {
        ArrayList<String> superinterfaces = new ArrayList<String>();
        InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.get(interfaceName);
        if (interfaceNode != null) {
            for (DAGNode superNode : interfaceNode.allSuperNodes) {
                superinterfaces.add(superNode.name);
            }
        }
        return superinterfaces;
    }

    public void linkToSuperclassAndInterfaces(String className, String superclassName, ArrayList<String> interfaces, HashSet<String> annotations) {
        ClassNode thisClassNode = this.classNameToClassNode.get(className);
        if (thisClassNode == null) {
            thisClassNode = new ClassNode(className, interfaces, annotations);
            this.classNameToClassNode.put(className, thisClassNode);
        } else {
            thisClassNode.encounter(interfaces, annotations);
        }
        ClassNode superclassNode = this.classNameToClassNode.get(superclassName);
        if (superclassNode == null) {
            superclassNode = new ClassNode(superclassName, thisClassNode);
            this.classNameToClassNode.put(superclassName, superclassNode);
        } else {
            superclassNode.addSubNode(thisClassNode);
        }
    }

    public void linkToSuperinterfaces(String interfaceName, ArrayList<String> superInterfaces) {
        InterfaceNode thisInterfaceInfo = this.interfaceNameToInterfaceNode.get(interfaceName);
        if (thisInterfaceInfo == null) {
            thisInterfaceInfo = new InterfaceNode(interfaceName);
            this.interfaceNameToInterfaceNode.put(interfaceName, thisInterfaceInfo);
        } else {
            thisInterfaceInfo.encounter();
        }
        if (superInterfaces != null) {
            for (String superInterfaceName : superInterfaces) {
                InterfaceNode superInterfaceNode = this.interfaceNameToInterfaceNode.get(superInterfaceName);
                if (superInterfaceNode == null) {
                    superInterfaceNode = new InterfaceNode(superInterfaceName, thisInterfaceInfo);
                    this.interfaceNameToInterfaceNode.put(superInterfaceName, superInterfaceNode);
                    continue;
                }
                superInterfaceNode.addSubNode(thisInterfaceInfo);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void finalizeNodes() {
        int i;
        if (this.classNameToClassNode.isEmpty() && this.interfaceNameToInterfaceNode.isEmpty()) {
            return;
        }
        ArrayList<DAGNode> classNodeTopoOrder = DAGNode.topoSort(this.classNameToClassNode.values());
        int n = classNodeTopoOrder.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DAGNode classNode = classNodeTopoOrder.get(i2);
            HashSet<DAGNode> allSuperNodes = new HashSet<DAGNode>(classNode.allSuperNodes);
            for (DAGNode dAGNode : classNode.allSuperNodes) {
                allSuperNodes.addAll(dAGNode.allSuperNodes);
            }
            classNode.allSuperNodes = allSuperNodes;
        }
        for (int i2 = classNodeTopoOrder.size() - 1; i2 >= 0; --i2) {
            DAGNode classNode = classNodeTopoOrder.get(i2);
            HashSet<DAGNode> allSubNodes = new HashSet<DAGNode>(classNode.allSubNodes);
            for (DAGNode dAGNode : classNode.allSubNodes) {
                allSubNodes.addAll(dAGNode.allSubNodes);
            }
            classNode.allSubNodes = allSubNodes;
        }
        ArrayList<DAGNode> interfaceNodeTopoOrder = DAGNode.topoSort(this.interfaceNameToInterfaceNode.values());
        int n2 = interfaceNodeTopoOrder.size();
        for (i = 0; i < n2; ++i) {
            DAGNode interfaceNode = interfaceNodeTopoOrder.get(i);
            HashSet<DAGNode> hashSet = new HashSet<DAGNode>(interfaceNode.allSuperNodes);
            for (DAGNode dAGNode : interfaceNode.allSuperNodes) {
                hashSet.addAll(dAGNode.allSuperNodes);
            }
            interfaceNode.allSuperNodes = hashSet;
        }
        for (i = interfaceNodeTopoOrder.size() - 1; i >= 0; --i) {
            DAGNode interfaceNode = interfaceNodeTopoOrder.get(i);
            HashSet<DAGNode> allSubNodes = new HashSet<DAGNode>(interfaceNode.allSubNodes);
            for (DAGNode dAGNode : interfaceNode.allSubNodes) {
                allSubNodes.addAll(dAGNode.allSubNodes);
            }
            interfaceNode.allSubNodes = allSubNodes;
        }
        HashMap<String, HashSet<DAGNode>> annotationToClassNodes = new HashMap<String, HashSet<DAGNode>>();
        HashMap interfaceToClassNodes = new HashMap();
        for (DAGNode dAGNode : classNodeTopoOrder) {
            ClassNode classNode = (ClassNode)dAGNode;
            if (classNode.annotationNames != null) {
                for (String string : classNode.annotationNames) {
                    HashSet<DAGNode> classList = (HashSet<DAGNode>)annotationToClassNodes.get(string);
                    if (classList == null) {
                        classList = new HashSet<DAGNode>();
                        annotationToClassNodes.put(string, classList);
                    }
                    classList.add(dAGNode);
                }
            }
            if (classNode.interfaceNames == null) continue;
            HashSet<String> hashSet = new HashSet<String>();
            for (String interfaceName : classNode.interfaceNames) {
                hashSet.add(interfaceName);
                InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.get(interfaceName);
                if (interfaceNode == null) continue;
                for (DAGNode superinterfaceNode : interfaceNode.allSuperNodes) {
                    hashSet.add(superinterfaceNode.name);
                }
            }
            for (String interfaceName : hashSet) {
                HashSet<DAGNode> classList = (HashSet<DAGNode>)interfaceToClassNodes.get(interfaceName);
                if (classList == null) {
                    classList = new HashSet<DAGNode>();
                    interfaceToClassNodes.put(interfaceName, classList);
                }
                classList.add(dAGNode);
            }
        }
        for (DAGNode dAGNode : interfaceNodeTopoOrder) {
            void var9_58;
            HashSet hashSet = (HashSet)interfaceToClassNodes.get(dAGNode.name);
            if (hashSet == null) continue;
            HashSet<DAGNode> hashSet2 = new HashSet<DAGNode>(hashSet);
            for (DAGNode implementingClass : hashSet) {
                hashSet2.addAll(implementingClass.allSubNodes);
            }
            HashSet hashSet3 = (HashSet)interfaceToClassNodes.get(dAGNode.name);
            if (hashSet3 == null) {
                HashSet hashSet4 = new HashSet();
                interfaceToClassNodes.put(dAGNode.name, hashSet4);
            }
            var9_58.addAll(hashSet2);
        }
        for (Map.Entry entry : annotationToClassNodes.entrySet()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.annotationNameToClassName.put((String)entry.getKey(), arrayList);
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null) continue;
            for (DAGNode classNode : hashSet) {
                arrayList.add(classNode.name);
            }
        }
        for (Map.Entry entry : interfaceToClassNodes.entrySet()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.interfaceNameToClassNames.put((String)entry.getKey(), arrayList);
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null) continue;
            for (DAGNode classNode : hashSet) {
                arrayList.add(classNode.name);
            }
        }
    }

    public void reset() {
        this.classNameToClassNode.clear();
        this.interfaceNameToInterfaceNode.clear();
        this.annotationNameToClassName.clear();
        this.interfaceNameToClassNames.clear();
    }
}

