/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FastClasspathScanner {
    private final String[] pathsToScan;
    private long lastModified = 0L;
    private static final boolean USE_ZIPFILE_ENTRY_MODIFICATION_TIMES = false;
    private final ArrayList<ClassMatcher> classMatchers = new ArrayList();
    private final ArrayList<FilePathMatcher> filePathMatchers = new ArrayList();
    private final HashMap<String, HashMap<String, StaticFinalFieldMatchProcessor>> classNameToStaticFieldnameToMatchProcessor = new HashMap();
    private final HashSet<String> classesEncounteredSoFarDuringScan = new HashSet();
    private final ClassGraphBuilder classGraphBuilder = new ClassGraphBuilder();

    public FastClasspathScanner(String[] packagesToScan) {
        HashSet<String> uniquePathsToScan = new HashSet<String>();
        for (String packageToScan : packagesToScan) {
            uniquePathsToScan.add(packageToScan.replace('.', '/') + "/");
        }
        this.pathsToScan = new String[uniquePathsToScan.size()];
        int i = 0;
        for (String uniquePathToScan : uniquePathsToScan) {
            this.pathsToScan[i++] = uniquePathToScan;
        }
    }

    public <T> FastClasspathScanner matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        if (superclass.isInterface()) {
            throw new IllegalArgumentException(superclass.getName() + " is an interface, not a regular class");
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String subclass : FastClasspathScanner.this.classGraphBuilder.getSubclassesOf(superclass.getName())) {
                    try {
                        Class<?> klass = Class.forName(subclass);
                        subclassMatchProcessor.processMatch(klass);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this;
    }

    public <T> FastClasspathScanner matchSubinterfacesOf(final Class<T> superInterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        if (!superInterface.isInterface()) {
            throw new IllegalArgumentException(superInterface.getName() + " is not an interface");
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String subInterface : FastClasspathScanner.this.classGraphBuilder.getSubinterfacesOf(superInterface.getName())) {
                    try {
                        Class<?> klass = Class.forName(subInterface);
                        subinterfaceMatchProcessor.processMatch(klass);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this;
    }

    public <T> FastClasspathScanner matchClassesImplementing(final Class<T> implementedInterface, final InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        if (!implementedInterface.isInterface()) {
            throw new IllegalArgumentException(implementedInterface.getName() + " is not an interface");
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String implClass : FastClasspathScanner.this.classGraphBuilder.getClassesImplementing(implementedInterface.getName())) {
                    try {
                        Class<?> klass = Class.forName(implClass);
                        interfaceMatchProcessor.processMatch(klass);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotation.getName() + " is not an annotation");
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String classWithAnnotation : FastClasspathScanner.this.classGraphBuilder.getClassesWithAnnotation(annotation.getName())) {
                    try {
                        Class<?> klass = Class.forName(classWithAnnotation);
                        classAnnotationMatchProcessor.processMatch(klass);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(HashSet<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            HashMap<String, StaticFinalFieldMatchProcessor> fieldNameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
            if (fieldNameToMatchProcessor == null) {
                fieldNameToMatchProcessor = new HashMap();
                this.classNameToStaticFieldnameToMatchProcessor.put(className, fieldNameToMatchProcessor);
            }
            fieldNameToMatchProcessor.put(fieldName, staticFinalFieldMatchProcessor);
        }
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String filenameMatchPattern, FileMatchProcessor fileMatchProcessor) {
        this.filePathMatchers.add(new FilePathMatcher(Pattern.compile(filenameMatchPattern), fileMatchProcessor));
        return this;
    }

    private String readAnnotation(DataInputStream inp, Object[] constantPool) throws IOException {
        String annotationFieldDescriptor = FastClasspathScanner.readRefdString(inp, constantPool);
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        int numElementValuePairs = inp.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            inp.skipBytes(2);
            this.readAnnotationElementValue(inp, constantPool);
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue(DataInputStream inp, Object[] constantPool) throws IOException {
        int tag = inp.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                inp.skipBytes(2);
                break;
            }
            case 101: {
                inp.skipBytes(4);
                break;
            }
            case 99: {
                inp.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(inp, constantPool);
                break;
            }
            case 91: {
                int count = inp.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue(inp, constantPool);
                }
                break;
            }
        }
    }

    private static String readRefdString(DataInputStream inp, Object[] constantPool) throws IOException {
        return (String)constantPool[inp.readUnsignedShort()];
    }

    private void readClassInfoFromClassfileHeader(InputStream inputStream) throws IOException {
        int attributesCount;
        int i;
        DataInputStream inp = new DataInputStream(new BufferedInputStream(inputStream, 1024));
        if (inp.readInt() != -889275714) {
            return;
        }
        inp.readUnsignedShort();
        inp.readUnsignedShort();
        int cpCount = inp.readUnsignedShort();
        Object[] constantPool = new Object[cpCount];
        int[] indirectStringRef = new int[cpCount];
        Arrays.fill(indirectStringRef, -1);
        block30: for (i = 1; i < cpCount; ++i) {
            int tag = inp.readUnsignedByte();
            switch (tag) {
                case 1: {
                    constantPool[i] = inp.readUTF();
                    continue block30;
                }
                case 3: {
                    constantPool[i] = inp.readInt();
                    continue block30;
                }
                case 4: {
                    constantPool[i] = Float.valueOf(inp.readFloat());
                    continue block30;
                }
                case 5: {
                    constantPool[i] = inp.readLong();
                    ++i;
                    continue block30;
                }
                case 6: {
                    constantPool[i] = inp.readDouble();
                    ++i;
                    continue block30;
                }
                case 7: 
                case 8: {
                    indirectStringRef[i] = inp.readUnsignedShort();
                    continue block30;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    inp.skipBytes(4);
                    continue block30;
                }
                case 15: {
                    inp.skipBytes(3);
                    continue block30;
                }
                case 16: {
                    inp.skipBytes(2);
                    continue block30;
                }
                case 18: {
                    inp.skipBytes(4);
                    continue block30;
                }
            }
        }
        for (i = 1; i < cpCount; ++i) {
            if (indirectStringRef[i] < 0) continue;
            constantPool[i] = constantPool[indirectStringRef[i]];
        }
        int flags = inp.readUnsignedShort();
        boolean isInterface = (flags & 0x200) != 0;
        String className = FastClasspathScanner.readRefdString(inp, constantPool).replace('/', '.');
        if (!this.classesEncounteredSoFarDuringScan.add(className)) {
            return;
        }
        String superclassName = FastClasspathScanner.readRefdString(inp, constantPool).replace('/', '.');
        HashMap<String, StaticFinalFieldMatchProcessor> staticFieldnameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        int interfaceCount = inp.readUnsignedShort();
        ArrayList<String> interfaces = interfaceCount > 0 ? new ArrayList<String>() : null;
        for (int i2 = 0; i2 < interfaceCount; ++i2) {
            interfaces.add(FastClasspathScanner.readRefdString(inp, constantPool).replace('/', '.'));
        }
        int fieldCount = inp.readUnsignedShort();
        for (int i3 = 0; i3 < fieldCount; ++i3) {
            int accessFlags = inp.readUnsignedShort();
            boolean isStaticFinal = (accessFlags & 0x18) == 24;
            String fieldName = FastClasspathScanner.readRefdString(inp, constantPool);
            StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor = staticFieldnameToMatchProcessor != null ? staticFieldnameToMatchProcessor.get(fieldName) : null;
            String descriptor = FastClasspathScanner.readRefdString(inp, constantPool);
            int attributesCount2 = inp.readUnsignedShort();
            if (!isStaticFinal && staticFinalFieldMatchProcessor != null) {
                System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": cannot match requested field " + className + "." + fieldName + " because it is either not static or not final");
                continue;
            }
            if (!isStaticFinal || staticFinalFieldMatchProcessor == null) {
                for (int j = 0; j < attributesCount2; ++j) {
                    inp.skipBytes(2);
                    int attributeLength = inp.readInt();
                    inp.skipBytes(attributeLength);
                }
                continue;
            }
            boolean foundConstantValue = false;
            for (int j = 0; j < attributesCount2; ++j) {
                String attributeName = FastClasspathScanner.readRefdString(inp, constantPool);
                int attributeLength = inp.readInt();
                if (attributeName.equals("ConstantValue")) {
                    Object constValue = constantPool[inp.readUnsignedShort()];
                    switch (descriptor) {
                        case "B": {
                            constValue = ((Integer)constValue).byteValue();
                            break;
                        }
                        case "C": {
                            constValue = Character.valueOf((char)((Integer)constValue).intValue());
                            break;
                        }
                        case "S": {
                            constValue = ((Integer)constValue).shortValue();
                            break;
                        }
                        case "Z": {
                            constValue = (Integer)constValue != 0;
                            break;
                        }
                        case "I": 
                        case "J": 
                        case "F": 
                        case "D": 
                        case "Ljava.lang.String;": {
                            break;
                        }
                    }
                    staticFinalFieldMatchProcessor.processMatch(className, fieldName, constValue);
                    foundConstantValue = true;
                } else {
                    inp.skipBytes(attributeLength);
                }
                if (foundConstantValue) continue;
                System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": Requested static final field " + className + "." + fieldName + "is not initialized with a constant literal value, so there is no " + "initializer value in the constant pool of the classfile");
            }
        }
        int methodCount = inp.readUnsignedShort();
        for (int i4 = 0; i4 < methodCount; ++i4) {
            inp.skipBytes(6);
            attributesCount = inp.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                inp.skipBytes(2);
                int attributeLength = inp.readInt();
                inp.skipBytes(attributeLength);
            }
        }
        HashSet<String> annotations = null;
        attributesCount = inp.readUnsignedShort();
        for (int i5 = 0; i5 < attributesCount; ++i5) {
            String attributeName = FastClasspathScanner.readRefdString(inp, constantPool);
            int attributeLength = inp.readInt();
            if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                int annotationCount = inp.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    String annotationName = this.readAnnotation(inp, constantPool);
                    if (annotations == null) {
                        annotations = new HashSet<String>();
                    }
                    annotations.add(annotationName);
                }
                continue;
            }
            inp.skipBytes(attributeLength);
        }
        if (isInterface) {
            this.classGraphBuilder.linkToSuperinterfaces(className, interfaces);
        } else {
            this.classGraphBuilder.linkToSuperclassAndInterfaces(className, superclassName, interfaces, annotations);
        }
    }

    private void scanFile(File file, String absolutePath, String relativePath, boolean scanTimestampsOnly) throws IOException {
        this.lastModified = Math.max(this.lastModified, file.lastModified());
        if (!scanTimestampsOnly) {
            if (relativePath.endsWith(".class")) {
                try (FileInputStream inputStream = new FileInputStream(file);){
                    this.readClassInfoFromClassfileHeader(inputStream);
                }
            }
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                if (!fileMatcher.pattern.matcher(relativePath).matches()) continue;
                FileInputStream inputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    fileMatcher.fileMatchProcessor.processMatch(absolutePath, relativePath, inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
        }
    }

    private void scanDir(File dir, int ignorePrefixLen, boolean scanTimestampsOnly) throws IOException {
        String relativePath;
        String absolutePath = dir.getPath();
        String string = relativePath = ignorePrefixLen > absolutePath.length() ? "" : absolutePath.substring(ignorePrefixLen);
        if (File.separatorChar != '/') {
            relativePath = relativePath.replace(File.separatorChar, '/');
        }
        boolean scanDirs = false;
        boolean scanFiles = false;
        for (String pathToScan : this.pathsToScan) {
            if (relativePath.startsWith(pathToScan) || relativePath.length() == pathToScan.length() - 1 && pathToScan.startsWith(relativePath)) {
                scanFiles = true;
                scanDirs = true;
                break;
            }
            if (!pathToScan.startsWith(relativePath)) continue;
            scanDirs = true;
        }
        if (scanDirs || scanFiles) {
            File[] subFiles;
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            for (File subFile : subFiles = dir.listFiles()) {
                if (subFile.isDirectory()) {
                    this.scanDir(subFile, ignorePrefixLen, scanTimestampsOnly);
                    continue;
                }
                if (!scanFiles || !subFile.isFile()) continue;
                String leafSuffix = "/" + subFile.getName();
                this.scanFile(subFile, absolutePath + leafSuffix, relativePath + leafSuffix, scanTimestampsOnly);
            }
        }
    }

    private void scanZipfile(String zipfilePath, ZipFile zipFile, long zipFileLastModified, boolean scanTimestampsOnly) throws IOException {
        boolean timestampWarning = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            boolean scanFile = false;
            for (String string : this.pathsToScan) {
                if (!path.startsWith(string)) continue;
                scanFile = true;
                break;
            }
            if (!scanFile) continue;
            long entryTime = zipFileLastModified;
            this.lastModified = Math.max(this.lastModified, entryTime);
            if (entryTime > System.currentTimeMillis() && !timestampWarning) {
                String msg = zipfilePath + " contains modification timestamps after the current time";
                System.err.println(msg);
                timestampWarning = true;
            }
            if (scanTimestampsOnly) continue;
            if (path.endsWith(".class")) {
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    this.readClassInfoFromClassfileHeader(inputStream);
                    continue;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    inputStream.close();
                    continue;
                }
            }
            for (FilePathMatcher filePathMatcher : this.filePathMatchers) {
                if (!filePathMatcher.pattern.matcher(path).matches()) continue;
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    filePathMatcher.fileMatchProcessor.processMatch(path, path, inputStream);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    public static ArrayList<File> getUniqueClasspathElements() {
        String[] pathElements = System.getProperty("java.class.path").split(File.pathSeparator);
        HashSet<String> pathElementsSet = new HashSet<String>();
        ArrayList<File> pathFiles = new ArrayList<File>();
        for (String pathElement : pathElements) {
            File file;
            if (!pathElementsSet.add(pathElement) || !(file = new File(pathElement)).exists()) continue;
            pathFiles.add(file);
        }
        return pathFiles;
    }

    private void scan(boolean scanTimestampsOnly) {
        this.classesEncounteredSoFarDuringScan.clear();
        if (!scanTimestampsOnly) {
            this.classGraphBuilder.reset();
        }
        try {
            for (File pathElt : FastClasspathScanner.getUniqueClasspathElements()) {
                String path = pathElt.getPath();
                if (pathElt.isDirectory()) {
                    this.scanDir(pathElt, path.length() + 1, scanTimestampsOnly);
                    continue;
                }
                if (!pathElt.isFile()) continue;
                String pathLower = path.toLowerCase();
                if (pathLower.endsWith(".jar") || pathLower.endsWith(".zip")) {
                    this.scanZipfile(path, new ZipFile(pathElt), pathElt.lastModified(), scanTimestampsOnly);
                    continue;
                }
                this.scanFile(pathElt, path, pathElt.getName(), scanTimestampsOnly);
                for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                    if (!fileMatcher.pattern.matcher(path).matches()) continue;
                    FileInputStream inputStream = new FileInputStream(pathElt);
                    Throwable throwable = null;
                    try {
                        fileMatcher.fileMatchProcessor.processMatch(path, pathElt.getName(), inputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!scanTimestampsOnly) {
            this.classGraphBuilder.finalizeNodes();
            for (ClassMatcher classMatcher : this.classMatchers) {
                classMatcher.lookForMatches();
            }
        }
    }

    public void scan() {
        this.scan(false);
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    private static interface ClassMatcher {
        public void lookForMatches();
    }

    private static class FilePathMatcher {
        Pattern pattern;
        FileMatchProcessor fileMatchProcessor;

        public FilePathMatcher(Pattern pattern, FileMatchProcessor fileMatchProcessor) {
            this.pattern = pattern;
            this.fileMatchProcessor = fileMatchProcessor;
        }
    }
}

